<?php
namespace App\Services\Frontend\Socialite;

use App\Models\User;
use Illuminate\Support\Facades\Auth;

class FacebookLoginService
{
    function loginUser($facebookUser)
    {
        $user = User::where('email', $facebookUser->email)->first();

        if (!$user) {
            $newUser = User::create([
                'username' => $user->name,
                'email' => $user->email,
                'google_id' => $user->id,
            ]);

            Auth::login($newUser);
        }

        return ['status' => true, 'message' => tt_trans('Successfully logged In')];
    }
}
