<?php

namespace App\Services\Frontend\Support;

use App\Events\NotificationEvent;
use App\Models\Support;
use App\Models\Admin;
use App\Models\SupportFile;
use App\Models\SupportMessage;

class SupportService
{
    function createSupport(array $payloads)
    {
        $support = Support::create([
            'user_id' => user()->id,
            'title' => $payloads['title'],
            'trx' => getTrx(),
        ]);

        $message = SupportMessage::create([
            'support_id' => $support->id,
            'message' => $payloads['message'],
        ]);

        if (isset($payloads['files'])) {
            foreach ($payloads['files'] as $file) {
                SupportFile::create([
                    'support_id' => $support->id,
                    'support_message_id' => $message->id,
                    'file' => storeFile($file, 'support')
                ]);
            }
        }

        $message = user()->username . ' opens a support Ticket';
        
        event(new NotificationEvent($support,user(), $message,'support_created'));

        return ['status' => true, 'message' => tt_trans('New Support Ticket Opened',cons()::LANGUAGE_NOTIFICATION)];
    }

    function storeReply(array $payloads, $support){

        $message = SupportMessage::create([
            'support_id' => $support->id,
            'message' => $payloads['message'],
        ]);

        if (isset($payloads['files'])) {
            foreach ($payloads['files'] as $file) {
                SupportFile::create([
                    'support_id' => $support->id,
                    'support_message_id' => $message->id,
                    'file' => storeFile($file, 'support')
                ]);
            }
        }

        $message = user()->username . ' reply for a support Ticket';

        event(new NotificationEvent($support,user(), $message,'support_reply'));


        return ['status' => true, 'message' => tt_trans('Reply support ticket successfully',cons()::LANGUAGE_NOTIFICATION)];
    }
}
