<?php
namespace App\Services\Frontend\TwoFa;

use BaconQrCode\Renderer\GDLibRenderer;
use Illuminate\Support\Facades\Hash;
use BaconQrCode\Writer;

class TwoFaService
{
    function google2fa()
    {
        return new \PragmaRX\Google2FAQRCode\Google2FA();
    }

    function generateQrCode()
    {
        $google2fa = app('pragmarx.google2fa');

        $payloads['secret'] = user()->ability->secret_code;

        $payloads['qrimage'] = $google2fa->getQRCodeUrl(tc()->get('sitename'), user()->email, $payloads['secret']);

        $renderer = new GDLibRenderer(200);
        $writer = new Writer($renderer);
        $qrCodePng = $writer->writeString($payloads['qrimage']);

        $payloads['qrimage'] = base64_encode($qrCodePng);

        return $payloads;
    }

    function enableTwoFa(array $payloads)
    {
        $google2fa = $this->google2fa();

        if (!$google2fa->verifyKey(user()->ability->secret_code, $payloads['password'])) {
            return ['status' => false, 'message' => tt_trans('The one time password is invalid.', cons()::LANGUAGE_NOTIFICATION)];
        }

        $user = user();

        $user->ability->twofa_enabled = cons()::ACTIVE;

        $user->ability->save();

        return ['status' => true, 'message' => tt_trans('Enable Two Factor Authentication Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function verifyOtp(array $payloads)
    {
        $google2fa = $this->google2fa();

        if (!$google2fa->verifyKey(user()->ability->secret_code, $payloads['password'])) {
            return ['status' => false, 'message' => tt_trans('The one time password is invalid.', cons()::LANGUAGE_NOTIFICATION)];
        }

        session()->put('2fa', true);

        return ['status' => true, 'message' => tt_trans('2Fa authentication successfull', cons()::LANGUAGE_NOTIFICATION)];
    }

    function disableTwoFactorAuthentication(array $payloads)
    {
        if (!Hash::check($payloads['password'], user()->password)) {
            return ['status' => false, 'message' => tt_trans('Invalid Password', cons()::LANGUAGE_NOTIFICATION)];
        }

        $user = user();

        $user->ability->twofa_enabled = cons()::INACTIVE;

        $user->ability->save();

        return ['status' => true, 'message' => tt_trans('Disable 2fa successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
