<?php 
namespace App\Services\Frontend\Withdraw;

use App\Events\NotificationEvent;
use App\Models\Transaction;
use App\Models\Withdraw;
use App\Models\WithdrawMethod;

class WithdrawService{
    function makeWithdraw(array $payloads){

        $method = WithdrawMethod::find($payloads['method']);

        if(user()->todayWithdraws()->count() >= tc()->get('withdraw_limit')){
            return['status' => false,'message' => tt_trans('Today withdraw limit exceeded',cons()::LANGUAGE_NOTIFICATION)];
        }

        if($payloads['amount'] > user()->balance){
            return['status' => false,'message' => tt_trans('Insufficient balance',cons()::LANGUAGE_NOTIFICATION)];
        }

        if($payloads['amount'] < $method->min_amount || $payloads['amount'] > $method->max_amount){
            return['status' => false,'message' => tt_trans('Please follow withdraw limit',cons()::LANGUAGE_NOTIFICATION)];
        }

        $getableAmount =  $method->type == cons()::FIXED ? formatter(($payloads['amount'] - $method->charge)) : formatter($payloads['amount'] -  ($payloads['amount'] * $method->charge) / 100);

        if($getableAmount <= 0){
            return['status' => false,'message' => 'Invalid Amount'];
        }

        $data = [
            'method_id' => $method->id,
            'user_id' => user()->id,
            'trx' => getTrx(),
            'withdraw_amount' => $payloads['amount'],
            'charge' => $method->type == cons()::FIXED ? $method->charge : ($payloads['amount'] * $method->charge) / 100,
            'getable_amount' =>$getableAmount,
            'rate' => $method->rate,
            'getable_amount_in_method_currency' => $getableAmount * $method->rate, 
            'note' => $payloads['note']
        ];

        session()->put('withdraw', $data);

        return['status' => true,'message' => tt_trans('Please confirm your withdraw request',cons()::LANGUAGE_NOTIFICATION)];
        
    }

    function confirmWithdraw(){
        $payloads = session('withdraw') ?? [];

        if(count($payloads) <= 0){
            return['status' => false,'message' => tt_trans('Invalid Withdraw Request',cons()::LANGUAGE_NOTIFICATION)];
        }

        $withdraw = Withdraw::create($payloads);

        $user = user();

        $user->balance = $user->balance -  $payloads['withdraw_amount'];

        $user->save();

        Transaction::create([
            'user_id' => $user->id,
            'amount' => $payloads['withdraw_amount'],
            'reason' => 'Balance Deduction for withdraw request',
            'trx' => $payloads['trx'],
            'type' => '-'
        ]);

        $message = user()->username . ' request for a withdraw';

        event(new NotificationEvent($withdraw, $user, $message,'withdraw_created'));

        return['status' => true,'message' => tt_trans('Withdraw Request Successfully',cons()::LANGUAGE_NOTIFICATION)];
    }
}