<?php

namespace App\Traits;

use Illuminate\Support\Facades\Schema;

trait FormattableColumn
{
    public function getFormattableColumns()
    {
        $columns = Schema::getColumnListing($this->getTable());

        return collect($columns)
            ->filter(function ($column) {
                return in_array(Schema::getColumnType($this->getTable(), $column), ['integer', 'float', 'double', 'decimal']);
            })
            ->toArray();
    }

    public function getAttribute($key)
    {
        $hasPrefix = false;
        
        if (str_starts_with($key, 'cur_')) {
            $key = str_replace('cur_', '', $key);
            $hasPrefix = true;
        }

        if (method_exists($this, 'getFormattableColumns') && in_array($key, $this->getFormattableColumns())) {

            $value = parent::getAttribute($key);

            if($hasPrefix){
                return $this->formatWithCurrency($value);
            }

            return $this->formatNumericColumn($value);
        }

        return parent::getAttribute($key);
    }


    protected function formatWithCurrency($value)
    {
        return number_format($value, tc()->get('precision'), '.', '') . ' ' . tc()->get('currency');
    }

    protected function formatNumericColumn($value)
    {
        return number_format($value, tc()->get('precision'),'.', '');
    }
}
