<?php

namespace App\Traits\Payment;

use App\Events\NotificationEvent;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Models\Stage;
use App\Models\StagePurchase;
use App\Models\Transaction;
use Illuminate\Support\Facades\DB;

trait PaymentSuccess
{
    public static function completedTransaction($data, $module)
    {
        if ($module == cons()::DEPOSIT) {
            return self::depositSuccess($data);
        }

        if ($module == cons()::PAYMENT) {
            return self::paymentSuccess($data);
        }
    }

    public static function depositSuccess($data)
    {
        $user = user();

        $method = Gateway::find($data['method_id']);

        $data['status'] = cons()::ACTIVE;

        unset($data['module']);

        $deposit = Deposit::create($data);

        Transaction::create([
            'user_id' => $user->id,
            'amount' => $deposit->amount,
            'reason' => 'Deposit via ' . $method->name,
            'trx' => $deposit->trx,
            'type' => '+',
            'currency' => $method->currency,
            'formatter' => $method->currency_type == cons()::FIAT ? 2 : 8
        ]);

        sendReferralCommission($user, $deposit->amount, cons()::DEPOSIT);

        $message = user()->username . ' completed a deposit via ' . $method->name;

        event(new NotificationEvent($deposit, $user, $message, 'deposit_successful'));

        $user->balance += $deposit->amount;

        $user->save();

        return ['status' => true, 'message' => tt_trans('Deposit Completed Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }


    public static function paymentSuccess($data)
    {

        $user = user();
        $stageInfo = session("stage_buy_informations");

        $method = Gateway::find($data['method_id']);
        $stage = Stage::find($stageInfo['stage_id']);


        unset($data['module'], $data['type'], $data['amount_in_gateway_currency']);

        $purchase = new StagePurchase();
        $purchase->trx = $data['trx'];
        $purchase->stage_id = $stage->id;
        $purchase->user_id = $user->id;
        $purchase->token = $stageInfo['token'];
        $purchase->bonus_token = $stage->bonus_token;
        $purchase->base_price = $stage->base_price;
        $purchase->total_price = $stageInfo['price'];
        $purchase->currency_id = $stageInfo['currency_id'];
        $purchase->status = cons()::ACCEPTED;
        $purchase->payment_type = cons()::WITH_GATEWAY;
        $purchase->method_id = $method->id;
        $purchase->save();

        $user->token += ($purchase->token + $purchase->bonus_token);
        $user->save();

        sendReferralCommission(user(), $stage->base_price * $purchase->token, 'payment');

        Transaction::create([
            'trx' => $purchase->trx,
            'user_id' => $purchase->user_id,
            'amount' => $purchase->total_price,
            'reason' => 'Buy Token',
            'type' => '-',
            'currency' => $method->currency,
            'formatter' => $method->currency_type == cons()::FIAT ? 2 : 8
        ]);

        $message = "Purchase token using " . $method->name;

        event(new NotificationEvent($purchase, $user, $message, 'online_purchase_token'));

        return ['status' => true, 'message' => $message];
    }
}
