<script>
    'use strict';
    @if (count($errors) > 0)
        @foreach ($errors->getMessages() as $key => $error)

            var validationInput = $('form').find('[name="' + "{{ $key }}" + '"]').not('[type=hidden]');

            if (validationInput.length <= 0) {
                $.toast({
                    text: "<i class='fa-solid fa-circle-exclamation'></i>{{ tt_trans($error[0], cons()::LANGUAGE_NOTIFICATION) }}",
                    showHideTransition: 'slide',
                    bgColor: 'var(--warning)',
                    textColor: '#fff',
                    allowToastClose: true,
                    hideAfter: 3000,
                    stack: 5,
                    textAlign: 'left',
                    position: 'top-right'
                })
            } else {
                $('form').find('[name="' + "{{ $key }}" + '"]').not('[type=hidden]').addClass('is-invalid');
                $('form').find('[name="' + "{{ $key }}" + '"]').not('[type=hidden]').after(`
                    <div class="invalid-feedback">
                            {{ tt_trans($error[0], cons()::LANGUAGE_NOTIFICATION) }}
                    </div>
               `);
            }
        @endforeach
    @endif
</script>
@if (session()->has('error'))
    <script>
        'use strict'
        $.toast({
            text: "<i class='fa-solid fa-circle-exclamation'></i> {{ session('error') }}",
            showHideTransition: 'slide',
            bgColor: 'var(--warning)',
            textColor: '#fff',
            allowToastClose: true,
            hideAfter: 3000,
            stack: 5,
            textAlign: 'left',
            position: 'top-right'
        })
    </script>
@endif


@if (session()->has('success'))
    <script>
        'use strict'
        $.toast({
            text: "{{ session('success') }}",
            showHideTransition: 'slide',
            bgColor: 'var(--success)',
            textColor: '#fff',
            allowToastClose: true,
            hideAfter: 5000,
            stack: 5,
            textAlign: 'left',
            position: 'top-right'
        })
    </script>
@endif
