@extends('backend.layouts.master')

@section('panel')
    <div class="row gy-4">
        <div class="col-xxl-12">
            <div class="card">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                    <h4 class="card-title mb-0">{{ tt_trans('All Addons') }}</h4>
                </div>
                <div class="card-body">
                    <div class="row gy-3">

                        @forelse ($addons as $module)
                            @if ($module['status'])
                                <div class="col-lg-3">
                                    <div class="card h-100 {{$module['status'] == 3 ? 'comming-soon-addon' : ''}}">
                                        <div class="card-body h-100 d-flex flex-column">
                                            <div class="">
                                                <img src="{{ $module['image']}}" alt="image"
                                                    class="w-100 h-100 object-fit-cover">
                                            </div>
                                            <div class="d-flex flex-wrap align-items-center gap-3">
                                                <div>
                                                    <h4 class="mt-3 mb-0 h5">{{ $module['title'] }}</h4>

                                                </div>
                                            </div>

                                            <ul class="list-group mt-4 mb-3 bg-white text-sm">
                                                <li class="list-group-item bg-extra-light">
                                                    <h6 class="text-sm">
                                                        {{ tt_trans('Description', cons()::LANGUAGE_BACKEND) }}
                                                    </h6>
                                                    <p class="text-sm mb-0">{{ $module['details'] }}</p>
                                                </li>
                                            </ul>

                                            @php
                                                $addon = \App\Models\Addon::where(
                                                    'name',
                                                    $module['addon_placeholder'],
                                                )->first();
                                            @endphp

                                            <div class="mt-auto">
                                                <div class="d-flex flex-wrap gap-3">

                                                    @if ($addon)
                                                        <form action="{{ route('panel.addon-status', $addon->id) }}" method="post">
                                                            @csrf
                                                            <input type="hidden" name="module" value="{{ $addon->name }}">
                                                            @if ($addon->status)
                                                                <button class="btn btn-light-danger w-100"><i
                                                                        class="ri-eye-off-line"></i>
                                                                    {{ tt_trans('Deactive', cons()::LANGUAGE_BACKEND) }}</button>
                                                            @else
                                                                <button class="btn btn-light-success w-100"><i
                                                                        class="ri-eye-line"></i>
                                                                    {{ tt_trans('Enable', cons()::LANGUAGE_BACKEND) }}</button>
                                                            @endif
                                                        </form>
                                                    @else
                                                        <a class="btn btn-light-info flex-grow-1"
                                                            href="{{ $module['purchase_link'] }}" target="_blank"><i
                                                                class="ri-eye-off-line"></i>
                                                            {{ tt_trans('Purchase Now', cons()::LANGUAGE_BACKEND) }}</a>


                                                        <a class="btn btn-light-danger flex-grow-1"
                                                            href="{{ route('panel.install-addon', $module['id']) }}"><i
                                                                class="ri-eye-off-line"></i>
                                                            {{ tt_trans('Install', cons()::LANGUAGE_BACKEND) }}</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @empty
                            
                        <x-no-data></x-no-data>

                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .comming-soon-addon {
            position: relative;
        }

        .comming-soon-addon::before {
            position: absolute;
            content: 'Coming Soon';
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.4);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: #fff;
            border-radius: 12px;
            z-index: 1;
        }
    </style>
@endpush
