@extends('backend.layouts.master')

@section('panel')
    <div class="row gy-4 justify-content-center">
        <div class="col-xxl-6">
            <div class="card">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                    <h4 class="card-title mb-0">{{ tt_trans('Install Addon') }}</h4>
                </div>
                <div class="card-body">
                    <form action="" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row gy-3">

                            <div class="col-md-6">
                                <label class="form-label">{{ __('Licence key') }}</label>
                                <input type="text" name="licence_key" class="form-control" value="{{ old('licence_key') }}">
                                @error('licence_key')
                                    <div class="text-danger text-sm">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">{{ __('Codecanyon username') }}</label>
                                <input type="text" name="code_username" class="form-control" value="{{ old('code_username') }}">
                                @error('code_username')
                                    <div class="text-danger text-sm">{{ $message }}</div>
                                @enderror
                            </div>


                            <div class="col-md-12">
                                <label class="form-label">{{ __('Installation File') }}</label>
                                <input type="file" name="file" class="form-control">
                                @error('code_username')
                                    <div class="text-danger text-sm">{{ $message }}</div>
                                @enderror
                            </div>


                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary mt-3">{{tt_trans('Install',cons()::LANGUAGE_BACKEND)}}</button>

                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
