@extends('backend.layouts.master')
@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans('Running Auction', cons()::LANGUAGE_BACKEND) }}</h4>
            <form method="GET">
                <div class="d-flex flex-wrap align-items-center gap-2">

                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <div class="position-relative">
                            <input type="text" name="from" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{tt_trans('MM/DD/YYYY',cons()::LANGUAGE_BACKEND)}}" value="{{ request()->from }}">
                        </div>
                        <span>{{ tt_trans('to', cons()::LANGUAGE_BACKEND) }}</span>
                        <div class="position-relative">
                            <input type="text" name="to" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{tt_trans('MM/DD/YYYY',cons()::LANGUAGE_BACKEND)}}" value="{{ request()->to }}">
                        </div>
                    </div>

                    @if (request()->has('trx') || request()->has('to') || request()->has('from'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif


                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i> {{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}
                    </button>
                </div>
            </form>
        </div>
        <div class="card-body">

            <x-table :paginations="$auctions">
                <tr>
                    <th scope="col"><i class="ri-profile-line"></i>
                        {{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-profile-line"></i>
                        {{ tt_trans('Tokens', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-calendar-2-line"></i>
                        {{ tt_trans('Expect Percentage', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-secure-payment-line"></i>
                        {{ tt_trans('Remain Token', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-calendar-3-line"></i>
                        {{ tt_trans('End Date', cons()::LANGUAGE_BACKEND) }}</th>


                </tr>

                <x-slot name="tablebody">
                    @forelse ($auctions as $auction)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('users', $auction->user->image) }}" alt="image"
                                        class="avatar-lg">
                                    <div>
                                        <h6 class="text-sm mb-0"><a
                                                href="{{ route('panel.user.details', $auction->user->id) }}"
                                                class="text-primary text-line-1 w-120px">{{ $auction->user->full_name }}</a>
                                        </h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted text-line-1 w-120px">
                                            {{ $auction->user->email }}</p>
                                    </div>
                                </div>
                            </td>

                            <td>{{ $auction->tokens }} {{ getActiveStage()['setting']->token_symbol }}</td>
                            <td> {{ $auction->expected_profit_percentage }} %</td>
                            <td>{{ $auction->availableToken() }} {{ getActiveStage()['setting']->token_symbol }}</td>
                            <td> {{ dateFormatter($auction->end_date) }}</td>

                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse

                </x-slot>

            </x-table>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $(".datepickerWithIcon").datepicker({
                showOn: "button",
                buttonImageOnly: false,
            });
        })
    </script>
@endpush
