@extends('backend.layouts.auth')

@section('panel')
    <form method="POST">
        @csrf
        <div class="mb-3">
            <label class="form-label">{{ tt_trans('Email', cons()::LANGUAGE_BACKEND) }}</label>
            <div class="icon-field">
                <input type="email" name="email" class="form-control"
                    placeholder="Enter email" value="{{ old('email') }}">
                <span class="icon"><i class="ri-account-circle-line"></i></span>
                
            </div>
        </div>
        <x-recaptcha></x-recaptcha>
        <button type="submit"
            class="btn btn-primary w-100 py-2">{{ tt_trans('Send Reset Code', cons()::LANGUAGE_BACKEND) }}</button>
        
        <div class="text-center mt-2">
            <a href="{{ route('panel.login') }}"
                class="text-primary text-sm">{{ tt_trans('Back to Login', cons()::LANGUAGE_BACKEND) }}</a>
        </div>
    </form>
@endsection