@extends('backend.layouts.auth')

@section('panel')
    <form method="POST">
        @csrf
          
        <div class="mb-3">
            <label class="form-label">{{tt_trans('Email or username',cons()::LANGUAGE_BACKEND)}}</label>
            <div class="icon-field">
                <input type="text" name="email" class="form-control " placeholder="Enter email or username"  value="{{old('email')}}">
                <span class="icon"><i class="ri-account-circle-line"></i></span>
                
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">{{tt_trans('Password', cons()::LANGUAGE_BACKEND)}}</label>
            <div class="icon-field">
                <input type="password" name="password" class="form-control" placeholder="Enter Password" >
                <span class="icon"><i class="ri-lock-line"></i></span>
               
            </div>
        </div>

        <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
            <div class="form-check style-check">
                <input class="form-check-input" name="remember"  type="checkbox" id="flexCheckDefault">
                <label class="form-check-label text-sm" for="flexCheckDefault">
                    {{tt_trans('Remember me',cons()::LANGUAGE_BACKEND)}}
                </label>
            </div>
            <a href="{{route('panel.forgot-password')}}" class="text-primary text-sm">{{tt_trans('Forget Password',cons()::LANGUAGE_BACKEND)}}?</a>
        </div>

        <x-recaptcha></x-recaptcha>

        <button type="submit" class="btn btn-primary w-100 py-2">{{tt_trans('Login now',cons()::LANGUAGE_BACKEND)}}</button>

    </form>
@endsection
