@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
            <h4 class="card-title mb-0">{{ tt_trans('Manage Blog Category', cons()::LANGUAGE_BACKEND) }}</h4>

            <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center">
                <form class="d-flex align-items-center gap-2" method="GET">
                    <div class="position-relative">
                        <input type="text" name="name" class="form-control form-control-sm ps-35"
                            placeholder="{{tt_back('Category name')}}" value="{{ request()->name }}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i>
                        <span>{{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}</span>
                    </button>

                    @if (request()->has('name'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif
                </form>


                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addCategory">
                    <i class="ri-add-circle-line"></i> {{ tt_trans('Add New Category', cons()::LANGUAGE_BACKEND) }}
                </button>
            </div>
        </div>
        <div class="card-body">
            <x-table>
                <tr>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Category Name', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-group-2-line"></i> {{ tt_trans('Slug', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-pages-line"></i> {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody" :pagination="$categories">
                    @forelse ($categories as $category)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="card-icon bg-primary item-center text-white rounded-circle">
                                        <span class="text-xxl line-height-1">
                                            <iconify-icon icon="hugeicons:blockchain-01"></iconify-icon>
                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="text-sm mb-1">{{ tt_trans($category->name, cons()::LANGUAGE_BACKEND) }}
                                        </h6>
                                        <p class="text-xs mb-0 line-height-1 text-muted">
                                            {{ 'created ' . dateFormatter($category->created_at) }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                {{ $category->slug }}
                            </td>

                            <td>
                                <?= status($category) ?>
                            </td>

                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <button type="button" class="btn btn-icon btn-primary rounded-circle edit"
                                        data-category="{{ $category }}" data-bs-toggle="modal" data-bs-target="#edit"
                                        data-action="{{ route('panel.blog-category.update', $category->id) }}">
                                        <i class="ri-edit-line"></i>
                                    </button>
                                    <x-delete-button :action="route('panel.blog-category.destroy', $category->id)"></x-delete-button>
                                </div>
                            </td>
                        </tr>
                    @empty

                        <x-no-data></x-no-data>
                    @endforelse
                </x-slot>
            </x-table>
        </div>
    </div>

    <x-modal title="Add new category" id="addCategory" size="">
        <form action="{{ route('panel.blog-category.store') }}" method="POST">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Category name', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="name" class="form-control" placeholder="{{tt_back('Enter Category name')}}" required
                    value="{{ old('name') }}">

            </div>

            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Category status', cons()::LANGUAGE_BACKEND) }}</label>
                <select name="status" class="form-select">
                    <option value="{{ cons()::ACTIVE }}">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                    <option value="{{ cons()::INACTIVE }}">{{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}</option>
                </select>

            </div>


            <button type="submit" class="btn btn-primary">{{ tt_trans('Save Now', cons()::LANGUAGE_BACKEND) }}</button>


        </form>
    </x-modal>

    <x-modal title="Update category" id="edit" size="">
        <form method="POST">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Category name', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="name" class="form-control" placeholder="{{tt_back('Enter Category name')}}" required
                    value="{{ old('name') }}">

            </div>

            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Category status', cons()::LANGUAGE_BACKEND) }}</label>
                <select name="status" class="form-select">
                    <option value="{{ cons()::ACTIVE }}">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                    <option value="{{ cons()::INACTIVE }}">{{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}</option>
                </select>
            </div>

            <button type="submit" class="btn btn-primary">{{ tt_trans('Update Now', cons()::LANGUAGE_BACKEND) }}</button>

        </form>
    </x-modal>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict';

            $('.edit').on('click', function() {
                $('#edit').find('form').attr('action', $(this).data('action'))
                $('#edit').find('input[name=name]').val($(this).data('category').name)
                $('#edit').find('select[name=status]').val($(this).data('category').status)
            })
        })
    </script>
@endpush
