@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.blogs.update', $blog->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card">
                    <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                        <h4 class="card-title mb-0">{{ tt_trans('Update Blog') }}</h4>

                        <a href="{{ route('panel.blogs.index') }}" class="btn btn-sm btn-light"><i
                                class="ri-arrow-left-line"></i>{{ tt_trans('Back', cons()::LANGUAGE_BACKEND) }}</a>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">

                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label class="form-label">{{ tt_trans('Blog Image', cons()::LANGUAGE_BACKEND) }}</label>
                                    <div
                                        class="drop-zone drop-zone-sm border border-2 border-dashed border-light-primary rounded p-2 d-flex flex-column align-items-center justify-content-center bg-light-primary overflow-hidden text-center">
                                        <div
                                            class="prompt-text h-100 w-100 d-flex flex-column align-items-center justify-content-center">
                                            <span class="display-6 text-primary mb-3">
                                                <iconify-icon icon="solar:gallery-linear"></iconify-icon>
                                            </span>
                                            <h6 class="mb-1 text-sm"><span
                                                    class="font-semibold">{{ tt_trans('Click to upload', cons()::LANGUAGE_BACKEND) }}</span>
                                                {{ tt_trans('or drag and drop', cons()::LANGUAGE_BACKEND) }}</h6>
                                            <p class="text-xs mb-0 text-muted">
                                                {{ tt_trans('PNG, JPG or JPEG', cons()::LANGUAGE_BACKEND) }} </p>
                                        </div>
                                        <input type="file" name="image"
                                            class="opacity-0 visually-hidden drop-zone-input" />

                                        <div class="drop-zone-thumb" style="background-image:url({{ getFile('blogs', $blog->image) }})">
                                            <div class="overlay"><p class="thumbnail-file-name">{{$blog->image}}</p><p class="overlay-prompt-text">{{tt_trans('Drag and drop or click to replace',cons()::LANGUAGE_BACKEND)}}</p></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">{{ tt_trans('Blog Category') }}</label>
                                    <select name="category_id" class="form-select">
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ selectedOption($category->id == $blog->category_id) }}>
                                                {{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="mb-3">
                                    <label class="form-label">{{ tt_trans('Blog tags') }}</label>
                                    <select name="tags[]" multiple class="form-select-two form-select-two-tokenizer">
                                        @foreach ($blog->tags as $tag)
                                            <option value="{{ $tag }}" selected>{{ $tag }}</option>
                                        @endforeach
                                    </select>
                                </div>




                                <div class="mb-3">
                                    <label class="form-label">{{ tt_trans('Blog Status') }}</label>
                                    <select name="status" class="form-select">
                                        <option value="{{ cons()::ACTIVE }}"
                                            {{ selectedOption($blog->status == cons()::ACTIVE) }}>
                                            {{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                                        <option value="{{ cons()::INACTIVE }}"
                                            {{ selectedOption($blog->status == cons()::INACTIVE) }}>
                                            {{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}</option>
                                    </select>
                                </div>


                                <div class="mb-3">
                                    <label class="form-label">{{ tt_trans('Blog Show In Home') }}</label>
                                    <select name="is_show_in_home" class="form-select">
                                        <option value="{{ cons()::ACTIVE }}" {{ selectedOption($blog->is_show_in_home == cons()::ACTIVE) }}>
                                            {{ tt_trans('Yes', cons()::LANGUAGE_BACKEND) }}</option>
                                        <option value="{{ cons()::INACTIVE }}" {{ selectedOption($blog->is_show_in_home == cons()::INACTIVE) }}>
                                            {{ tt_trans('No', cons()::LANGUAGE_BACKEND) }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-8">

                                <div class="mb-3">
                                    <x-ai name="title" target="title" label="Blog Title" :value="$blog->title"></x-ai>
                                </div>
                                <div class="mb-3">
                                    <x-ai name="short_description" target="short_description" type="textarea" label="Short Description" :value="$blog->short_description"></x-ai>
                                </div>

                                <div class="">
                                    <x-ai name="description" target="description" type="editor" label="Description" :value="$blog->description"></x-ai>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h4 class="card-title">{{ tt_trans('Seo Information') }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-sm-12">
                                <label class="form-label">{{ tt_trans('Seo Tags') }}</label>
                                <select name="seo_tags[]" multiple class="form-select-two form-select-two-tokenizer">
                                    @foreach ($blog->seo_tags as $seo)
                                        <option value="{{ $seo }}" selected>{{ $seo }}</option>
                                    @endforeach
                                </select>
                            </div>


                            <div class="col-sm-12">
                                <label class="form-label">{{ tt_trans('Seo Description') }}</label>
                                <textarea name="seo_description" class="form-control" cols="30" rows="10">{{ $blog->seo_description }}</textarea>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <button type="submit"
                class="btn btn-primary mt-4">{{ tt_trans('Update Blog',cons()::LANGUAGE_BACKEND) }}</button>
        </div>
    </form>
@endsection



@push('script')
    <script src="{{ js('drop-zone.js',cons()::ASSETS_FROM_BACKEND) }}"></script>
@endpush
