@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
            <h4 class="card-title mb-0">{{ tt_trans('Manage Blogs', cons()::LANGUAGE_BACKEND) }}</h4>

            <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center">
                <form class="d-flex align-items-center gap-2" method="GET">
                    <div class="position-relative">
                        <input type="text" name="title" class="form-control form-control-sm ps-35"
                            placeholder="Blog Title" value="{{ request()->title }}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i>
                        <span>{{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}</span>
                    </button>
                </form>


                @if (request()->has('title'))
                        <a href="{{url()->current()}}" class="btn btn-sm btn-outline-danger"><i class="ri-close-large-line"></i>
                            {{tt_trans('Clear Filter',cons()::LANGUAGE_BACKEND)}}</a>
                    @endif


                <a class="btn btn-sm btn-primary" href="{{ route('panel.blogs.create') }}">
                    <i class="ri-add-circle-line"></i> {{ tt_trans('Add New Blog', cons()::LANGUAGE_BACKEND) }}
                </a>
            </div>
        </div>
        <div class="card-body">
            <x-table>
                <tr>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Blog Title', cons()::LANGUAGE_BACKEND) }}
                    </th>

                    <th scope="col"><i class="ri-pages-line"></i> {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse ($blogs as $blog)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('blogs', $blog->image) }}" alt="image" class="avatar-lg rounded-2">
                                    <div>
                                        <h6 class="text-sm mb-0"><a href="{{ route('panel.blogs.edit', $blog->id) }}"
                                                class="text-primary">{{ $blog->title }}</a></h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted">
                                            {{ dateFormatter($blog->created_at) }}</p>
                                    </div>
                                </div>
                            </td>

                            <td>
                                <?= status($blog) ?>
                            </td>

                            <td>
                                <a href="{{ route('panel.blogs.edit', $blog->id) }}"
                                    class="btn btn-icon btn-primary rounded-circle">
                                    <i class="ri-edit-line"></i>
                                </a>


                                <x-delete-button :action="route('panel.blogs.destroy', $blog->id)"></x-delete-button>

                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse

                </x-slot>

            </x-table>
        </div>
    </div>
@endsection
