@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
            <h4 class="card-title mb-0">{{ tt_trans('Manage Contacts', cons()::LANGUAGE_BACKEND) }}</h4>
        </div>
        <div class="card-body">
            <x-table :paginations="$contacts">
                <tr>
                    <th scope="col"><i class="ri-account-circle-line"></i>{{ tt_trans('Name', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-group-2-line"></i> {{ tt_trans('Email', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-pages-line"></i> {{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }}
                    </th>

                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">

                    @forelse ($contacts as $contact)
                        <tr>
                            <td>{{ $contact->name }}</td>
                            <td>{{ $contact->email }}</td>
                            <td>{{ $contact->subject }}</td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <button type="button" class="btn btn-icon btn-primary rounded-circle edit"
                                        data-message="{{ $contact->message }}" data-bs-toggle="modal"
                                        data-bs-target="#edit">
                                        <i class="ri-eye-line"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>

                    @empty
                        <x-no-data></x-no-data>
                    @endforelse


                </x-slot>
            </x-table>
        </div>
    </div>


    <x-modal title="Contact Message" id="edit">
        <p id="details">

        </p>
    </x-modal>
@endsection



@push('script')
    <script>
        $(function() {
            'use strict'

            $('.edit').on('click', function() {
                $('#edit').find('form').attr('action', $(this).data('action'))
                $('#edit').find('#details').text($(this).data('message'))
            })

        })
    </script>
@endpush
