@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.currency.store') }}" enctype="multipart/form-data">
        @csrf

        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card">
                    <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                        <h4 class="card-title mb-0">{{ tt_trans('Create Currency',cons()::LANGUAGE_BACKEND) }}</h4>

                        <a href="{{ route('panel.currency.index') }}" class="btn btn-sm btn-light"><i
                                class="ri-arrow-left-line"></i>{{ tt_trans('Back', cons()::LANGUAGE_BACKEND) }}</a>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">

                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('Currency Image', cons()::LANGUAGE_BACKEND) }}
                                    </label>
                                    <div
                                        class="drop-zone drop-zone-sm border border-2 border-dashed border-light-primary rounded p-2 d-flex flex-column align-items-center justify-content-center bg-light-primary overflow-hidden text-center">
                                        <div
                                            class="prompt-text h-100 w-100 d-flex flex-column align-items-center justify-content-center">
                                            <span class="display-6 text-primary mb-3">
                                                <iconify-icon icon="solar:gallery-linear"></iconify-icon>
                                            </span>
                                            <h6 class="mb-1 text-sm"><span
                                                    class="font-semibold">{{ tt_trans('Click to upload', cons()::LANGUAGE_BACKEND) }}</span>
                                                {{ tt_trans('or drag and drop', cons()::LANGUAGE_BACKEND) }}</h6>
                                            <p class="text-xs mb-0 text-muted">
                                                {{ tt_trans('PNG, JPG or JPEG', cons()::LANGUAGE_BACKEND) }} </p>
                                        </div>
                                        <input type="file" name="icon"
                                            class="opacity-0 visually-hidden drop-zone-input" />
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-8">
                                <div class="row gy-3">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Currency Name', cons()::LANGUAGE_BACKEND) }}</label>
                                            <input type="text" name="name" value="{{old('name')}}" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Exchange Rate', cons()::LANGUAGE_BACKEND) }}</label>
                                            <div class="input-group">
                                                <input type="number" step="any" name="exchange_rate"
                                                    class="form-control" value="{{old('exchange_rate')}}" required>
                                                <span class="input-group-text">{{ tc()->get('currency') }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Payment Gateway', cons()::LANGUAGE_BACKEND) }}</label>
                                            <select class="form-select-two" multiple="multiple" name="gateways[]"
                                                required>
                                                @foreach ($gateways as $gateway)
                                                    <option value="{{ $gateway->id }}">{{ $gateway->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Currency Type', cons()::LANGUAGE_BACKEND) }}</label>
                                            <select class="form-select" name="currency_type" required>
                                                <option value="{{ cons()::FIAT }}">
                                                    {{ tt_trans('Fiat', cons()::LANGUAGE_BACKEND) }}</option>
                                                <option value="{{ cons()::CRYPTO }}">
                                                    {{ tt_trans('Crypto', cons()::LANGUAGE_BACKEND) }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</label>
                                            <select class="form-select" name="status" required>
                                                <option value="{{ cons()::ACTIVE }}">
                                                    {{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                                                <option value="{{ cons()::INACTIVE }}">
                                                    {{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <button type="submit"
                class="btn btn-primary mt-4">{{ tt_trans('Create Currency', cons()::LANGUAGE_BACKEND) }}</button>
        </div>
    </form>
@endsection


@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
@endpush
