@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
            <h4 class="card-title mb-0">{{ tt_trans('Manage Currency', cons()::LANGUAGE_BACKEND) }}</h4>

            <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center">
                <form class="d-flex align-items-center gap-2" method="GET">
                    <div class="position-relative">
                        <input type="text" name="name" class="form-control form-control-sm ps-35"
                            placeholder="{{tt_trans('Currency name',cons()::LANGUAGE_BACKEND)}}" value="{{ request()->name }}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i>
                        <span>{{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}</span>
                    </button>

                    @if (request()->has('name'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif
                </form>


                <a class="btn btn-sm btn-primary" href="{{ route('panel.currency.create') }}">
                    <i class="ri-add-circle-line"></i> {{ tt_trans('Add New Currency', cons()::LANGUAGE_BACKEND) }}
                </a>
            </div>
        </div>
        <div class="card-body">
            <x-table>
                <tr>

                    <th scope="col"><i
                            class="ri-money-dollar-circle-line"></i>{{ tt_trans('Currency', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-exchange-dollar-fill"></i>
                        {{ tt_trans('Exchange Rate', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Type', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-pages-line"></i> {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody" :pagination="$currencies">
                    @forelse ($currencies as $currency)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('currency', $currency->icon) }}" alt="image"
                                        class="avatar-lg rounded-2">
                                    <div>
                                        <h6 class="text-sm mb-0">{{ $currency->name }}</h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted">
                                            {{ dateFormatter($currency->created_at) }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                {{ formatter($currency->exchange_rate) }} {{ tc()->get('currency') }}
                            </td>
                            <td>
                                {{ strtoupper($currency->currency_type) }}
                            </td>
                            <td>
                                <?= status($currency) ?>
                            </td>

                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <a href="{{ route('panel.currency.edit', $currency->id) }}"
                                        class="btn btn-icon btn-primary rounded-circle">
                                        <i class="ri-edit-line"></i>
                                    </a>
                                    <x-delete-button :action="route('panel.currency.destroy', $currency->id)"></x-delete-button>
                                </div>
                            </td>
                        </tr>
                    @empty

                        <x-no-data></x-no-data>
                    @endforelse
                </x-slot>
            </x-table>
        </div>
    </div>
@endsection
