@extends('backend.layouts.master')
@section('panel')

    <div class="row g-3">
        <div class="col-lg-3 col-sm-6">
            <div class="card p-3 rounded-2 border border-hovered-primary">
                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div
                        class="card-icon bg-light-primary rounded-circle d-flex justify-content-center align-items-center text-primary text-xl">
                        <iconify-icon icon="solar:wallet-outline"></iconify-icon>
                    </div>
                    <h4 class="text-md mb-0">{{ tt_trans('Total Deposits', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <hr>
                <div class="d-flex justify-content-between align-items-center">
                    <h4 class="h3 mb-0">{{ formatter($total_deposits, true) }}</h4>
                    <a href="{{ route('panel.online-deposits') }}" class="text-lg line-height-1 text-primary"><i
                            class="ri-arrow-right-up-line"></i></a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card p-3 rounded-2 border border-hovered-info">
                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div
                        class="card-icon bg-light-info rounded-circle d-flex justify-content-center align-items-center text-info text-xl">
                        <iconify-icon icon="solar:cash-out-outline"></iconify-icon>
                    </div>
                    <h4 class="text-md mb-0">{{ tt_trans('Total User Earnings', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <hr>
                <div class="d-flex justify-content-between align-items-center">
                    <h4 class="h3 mb-0">{{ formatter($total_earnings, true) }}</h4>
                    <a href="{{ route('panel.user-earnings-report') }}" class="text-lg line-height-1 text-info"><i
                            class="ri-arrow-right-up-line"></i></a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card p-3 rounded-2 border border-hovered-warning">
                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div
                        class="card-icon bg-light-warning rounded-circle d-flex justify-content-center align-items-center text-warning text-xl">
                        <iconify-icon icon="iconoir:hand-cash"></iconify-icon>
                    </div>
                    <h4 class="text-md mb-0">{{ tt_trans('Total Withdraw', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <hr>
                <div class="d-flex justify-content-between align-items-center">
                    <h4 class="h3 mb-0">{{ formatter($total_withdraw, true) }}</h4>
                    <a href="{{ route('panel.withdraw-request') }}" class="text-lg line-height-1 text-warning"><i
                            class="ri-arrow-right-up-line"></i></a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card p-3 rounded-2 border border-hovered-success">
                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div
                        class="card-icon bg-light-success rounded-circle d-flex justify-content-center align-items-center text-success text-xl">
                        <iconify-icon icon="heroicons:users"></iconify-icon>
                    </div>
                    <h4 class="text-md mb-0">{{ tt_trans('Total Users', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <hr>
                <div class="d-flex justify-content-between align-items-center">
                    <h4 class="h3 mb-0">{{ $total_users }}</h4>
                    <a href="{{ route('panel.users') }}" class="text-lg line-height-1 text-success"><i
                            class="ri-arrow-right-up-line"></i></a>
                </div>
            </div>
        </div>

    </div>

    <div class="row g-3 mt-1">

        <div class="col-lg-3 col-sm-6">
            <div class="card p-xxl-3 p-2 rounded-2 border border-hovered-success">
                <div class="d-flex flex-wrap align-items-center gap-xxl-3 gap-2">
                    <div
                        class="card-icon-lg bg-light-success rounded d-flex justify-content-center align-items-center text-success text-2xl">
                        <iconify-icon icon="mynaui:box"></iconify-icon>
                    </div>
                    <div>
                        <p class="mb-0 text-sm">{{ tt_trans('Total Stage', cons()::LANGUAGE_BACKEND) }}</p>
                        <h4 class="mb-0 h6">{{ $total_stages }}</h4>
                    </div>
                    <a href="{{ route('panel.stage.index') }}" class="text-success text-lg ms-auto">
                        <i class="ri-arrow-right-up-line"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card p-xxl-3 p-2 rounded-2 border border-hovered-primary">
                <div class="d-flex flex-wrap align-items-center gap-xxl-3 gap-2">
                    <div
                        class="card-icon-lg bg-light-primary rounded d-flex justify-content-center align-items-center text-primary text-2xl">
                        <iconify-icon icon="ri:nft-line"></iconify-icon>
                    </div>
                    <div>
                        <p class="mb-0 text-sm">{{ tt_trans('Token Purchase', cons()::LANGUAGE_BACKEND) }}</p>
                        <h4 class="mb-0 h6">{{ $total_token_sale }}</h4>
                    </div>
                    <a href="{{ route('panel.stage.purchases') }}" class="text-primary text-lg ms-auto">
                        <i class="ri-arrow-right-up-line"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card p-xxl-3 p-2 rounded-2 border border-hovered-info">
                <div class="d-flex flex-wrap align-items-center gap-xxl-3 gap-2">
                    <div
                        class="card-icon-lg bg-light-info rounded d-flex justify-content-center align-items-center text-info text-2xl">
                        <iconify-icon icon="ph:stack-plus"></iconify-icon>
                    </div>
                    <div>
                        <p class="mb-0 text-sm">{{ tt_trans('Total Auction', cons()::LANGUAGE_BACKEND) }}</p>
                        <h4 class="mb-0 h6">{{ $total_auction }}</h4>
                    </div>
                    <a href="{{ route('panel.stage.purchases') }}" class="text-info text-lg ms-auto">
                        <i class="ri-arrow-right-up-line"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card p-xxl-3 p-2 rounded-2 border border-hovered-warning">
                <div class="d-flex flex-wrap align-items-center gap-xxl-3 gap-2">
                    <div
                        class="card-icon-lg bg-light-warning rounded d-flex justify-content-center align-items-center text-warning text-2xl">
                        <iconify-icon icon="solar:dollar-linear"></iconify-icon>
                    </div>
                    <div>
                        <p class="mb-0 text-sm">{{ tt_trans('Auction Profit', cons()::LANGUAGE_BACKEND) }}</p>
                        <h4 class="mb-0 h6">{{ symbol($auction_profit) }}</h4>
                    </div>
                    <a href="{{ route('panel.stage.purchases') }}" class="text-warning text-lg ms-auto">
                        <i class="ri-arrow-right-up-line"></i>
                    </a>
                </div>
            </div>
        </div>

    </div>
    <div class="row g-3 mt-1">

        <div class="col-xxl-9 col-12">
            <div class="card h-100">
                <div class="card-header">
                    <h4 class="card-title mb-0">
                        {{ tt_trans('Deposit & Withdraw Statistics', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <div class="card-body overflow-hidden">
                    <div id="depositOverview"></div>
                </div>
            </div>
        </div>

        <div class="col-xxl-3 col-xl-6">
            <div class="card h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                    <h4 class="card-title mb-0">{{ tt_trans('Recent Notifications', cons()::LANGUAGE_BACKEND) }}
                    </h4>
                    <a href="{{ route('panel.notifications') }}"
                        class="text-xs text-primary fw-medium">{{ tt_trans('View All', cons()::LANGUAGE_BACKEND) }}
                        <i class="ri-arrow-right-line"></i></a>
                </div>
                <div class="card-body">
                    <div class="row gy-4 gx-0 {{ notifications()->isEmpty() ? 'h-100 align-items-center' : '' }}">
                        @forelse (notifications() as $notification)
                            <div class="col-12 d-flex align-items-center gap-3 position-relative">
                                <a href="{{ $notification->data['url'] }}"
                                    class="position-absolute top-0 start-0 w-100 h-100"></a>
                                <span
                                    class="card-icon flex-shrink-0 bg-primary text-white rounded-circle d-flex justify-content-center align-items-center text-xl">
                                    <iconify-icon icon="solar:wallet-linear"></iconify-icon>
                                </span>
                                <span class="d-block flex-grow-1 display-color flex-grow-1 text-line-1 line-height-1">
                                    {{ $notification->data['message'] }}
                                    <br>
                                    <span
                                        class="d-block mt-2 body-color text-xs">{{ dateFormatter($notification->created_at) }}</span>
                                </span>
                            </div>
                        @empty
                            <div class="col-12 d-flex flex-column align-items-center justify-content-center">
                                <div class="no-data-wrapper text-center">
                                    <img src="{{ getFile('common', 'no-data-sm.png') }}" alt="image"
                                        class="no-data-img">
                                    <h6 class="mt-4 mb-0 text-md">
                                        {{ tt_trans("Haven't any notification yet", cons()::LANGUAGE_BACKEND) }}
                                    </h6>
                                </div>
                            </div>
                        @endforelse

                    </div>
                </div>
            </div>
        </div>



        <div class="col-xxl-3 col-xl-6">
            <div class="card h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                    <h4 class="card-title mb-0">{{ tt_trans('Recent Users', cons()::LANGUAGE_BACKEND) }}</h4>
                    <a href="{{ route('panel.users') }}"
                        class="text-xs text-primary fw-medium">{{ tt_trans('View All', cons()::LANGUAGE_BACKEND) }}
                        <i class="ri-arrow-right-s-line"></i></a>
                </div>
                <div class="card-body">
                    @forelse ($latest_users as $user)
                        <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                            <div class="d-flex align-items-center gap-2">
                                <img src="{{ getFile('user', $user->image) }}" alt="image" class="avatar-lg">
                                <div>
                                    <h6 class="text-sm mb-0"><a href="{{ route('panel.user.details', $user->id) }}"
                                            class="w-150px text-line-1">{{ $user->full_name }}</a>
                                    </h6>
                                    <p class="text-xs mb-0 line-height-1 text-muted w-150px text-line-1">
                                        {{ $user->username }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge badge-light-{{ $user->ability?->kyc_verified ? 'success' : 'danger' }}"
                                    data-bs-toggle="tooltip"
                                    data-bs-title="{{ $user->ability?->kyc_verified ? 'KYC verified' : 'KYC unverified' }}">

                                    @if ($user->ability?->kyc_verified)
                                        <i class="ri-check-double-line"></i>
                                    @else
                                        <i class="ri-question-line"></i>
                                    @endif

                                    {{ tt_trans('KYC', cons()::LANGUAGE_BACKEND) }}
                                </span>
                                <span
                                    class="badge badge-light-{{ $user->ability?->email_verified ? 'success' : 'danger' }}"
                                    data-bs-toggle="tooltip"
                                    data-bs-title="{{ $user->ability?->email_verified ? 'Email verified' : 'Email unverified' }}">
                                    @if ($user->ability?->email_verified)
                                        <i class="ri-check-double-line"></i>
                                    @else
                                        <i class="ri-question-line"></i>
                                    @endif
                                    {{ tt_trans('Email', cons()::LANGUAGE_BACKEND) }}
                                </span>

                            </div>
                        </div>
                        <hr>
                    @empty
                        <x-no-data />
                    @endforelse

                </div>
            </div>
        </div>

        <div class="col-xxl-9 col-12">
            <div class="card h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                    <h4 class="card-title mb-0">{{ tt_trans('Latest Transactions', cons()::LANGUAGE_BACKEND) }}</h4>
                    <ul class="nav nav-tabs nav-tabs-sm bordered-tab border-0" id="transactionTab" role="tablist">


                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="tab5a-tab" data-bs-toggle="tab"
                                data-bs-target="#tab5a-tab-pane" type="button" role="tab"
                                aria-controls="tab5a-tab-pane"
                                aria-selected="false">{{ tt_trans('Deposit', cons()::LANGUAGE_BACKEND) }}</button>
                        </li>

                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="tab6a-tab" data-bs-toggle="tab"
                                data-bs-target="#tab6a-tab-pane" type="button" role="tab"
                                aria-controls="tab6a-tab-pane"
                                aria-selected="false">{{ tt_trans('Withdraw', cons()::LANGUAGE_BACKEND) }}</button>
                        </li>



                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content mt-0" id="myTabContent">
                        <div class="tab-pane fade " id="tab4a-tab-pane" role="tabpanel" aria-labelledby="tab4a-tab"
                            tabindex="0">

                        </div>
                        <div class="tab-pane fade show active" id="tab5a-tab-pane" role="tabpanel"
                            aria-labelledby="tab5a-tab" tabindex="0">
                            <x-table :paginations="$deposits">
                                <tr>
                                    <th scope="col"><i
                                            class="ri-account-circle-line"></i>{{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}
                                    </th>
                                    <th scope="col"><i class="ri-profile-line"></i>
                                        {{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}
                                    </th>
                                    <th scope="col"><i class="ri-calendar-2-line"></i>
                                        {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-secure-payment-line"></i>
                                        {{ tt_trans('Gateway', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-wallet-2-line"></i>
                                        {{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-wallet-3-line"></i>
                                        {{ tt_trans('Final Amount', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                                    @if (admin()->can('manage_deposits'))
                                        <th scope="col"><i class="ri-arrow-right-up-line"></i>
                                            {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                                    @endif
                                </tr>

                                <x-slot name="tablebody">
                                    @forelse ($deposits as $deposit)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-2">
                                                    <img src="{{ getFile('users', $deposit->user->image) }}"
                                                        alt="image" class="avatar-lg">
                                                    <div>
                                                        <h6 class="text-sm mb-0"><a
                                                                href="{{ route('panel.user.details', $deposit->user_id) }}"
                                                                class="text-primary text-line-1 w-120px">{{ $deposit->user->full_name }}</a>
                                                        </h6>
                                                        <p
                                                            class="text-xs mt-1 mb-0 line-height-1 text-muted text-line-1 w-120px">
                                                            {{ $deposit->user->email }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ $deposit->trx }}</td>
                                            <td class="text-nowrap">{{ dateFormatter($deposit->created_at) }}</td>
                                            <td>
                                                <span
                                                    class="badge badge-light-primary">{{ $deposit->method->name }}</span>
                                            </td>
                                            <td>
                                                {{ symbol($deposit->amount) }}
                                            </td>
                                            <td>{{ symbol($deposit->total_amount) }}
                                            </td>
                                            <td>
                                                <?= status($deposit, '', 'deposit') ?>
                                            </td>

                                            @if (admin()->can('manage_deposits'))
                                                <td>

                                                    @if ($deposit->type == cons()::OFFLINE_GATEWAY)
                                                        <div class="d-flex flex-wrap align-items-center gap-2">
                                                            <a href="{{ route('panel.offline-deposit-details', $deposit->id) }}"
                                                                class="btn btn-icon btn-primary rounded-circle">
                                                                <i class="ri-eye-line"></i>
                                                            </a>
                                                        </div>
                                                    @else
                                                        <div class="d-flex flex-wrap align-items-center gap-2">
                                                            <a href="javascript:void(0)" data-bs-toggle="modal"
                                                                data-bs-target="#details"
                                                                data-action="{{ route('panel.online-deposit-details', $deposit->id) }}"
                                                                class="btn btn-icon btn-primary rounded-circle details">
                                                                <i class="ri-eye-line"></i>
                                                            </a>
                                                        </div>
                                                    @endif
                                                </td>
                                            @endif
                                        </tr>
                                    @empty
                                        <x-no-data></x-no-data>
                                    @endforelse

                                </x-slot>

                            </x-table>
                        </div>
                        <div class="tab-pane fade" id="tab6a-tab-pane" role="tabpanel" aria-labelledby="tab6a-tab"
                            tabindex="0">
                            <x-table :paginations="$withdraw_requests">
                                <tr>
                                    <th scope="col"><i class="ri-account-circle-line"></i>
                                        {{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-profile-line"></i>
                                        {{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}
                                    </th>
                                    <th scope="col"><i class="ri-calendar-2-line"></i>
                                        {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-secure-payment-line"></i>
                                        {{ tt_trans('Gateway', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-wallet-2-line"></i>
                                        {{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-wallet-2-line"></i>
                                        {{ tt_trans('Charge', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-wallet-3-line"></i>
                                        {{ tt_trans('Final Amount', cons()::LANGUAGE_BACKEND) }}</th>
                                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                                    @if (admin()->can('manage_withdraw'))
                                        <th scope="col"><i class="ri-arrow-right-up-line"></i>
                                            {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                                    @endif
                                </tr>

                                <x-slot name="tablebody">
                                    @forelse ($withdraw_requests as $withdraw)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-2">
                                                    <img src="{{ getFile('user', $withdraw->user?->image) }}"
                                                        alt="image" class="avatar-lg">
                                                    <div>
                                                        <h6 class="text-sm mb-0">
                                                            <a href="{{ route('panel.user.details', $withdraw->user->id) }}"
                                                                class="text-primary">{{ $withdraw->user->username }}</a>
                                                        </h6>
                                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted">
                                                            {{ $withdraw->user->email }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ $withdraw->trx }}</td>
                                            <td>{{ dateFormatter($withdraw->created_at) }}</td>
                                            <td>
                                                <span
                                                    class="badge badge-light-primary">{{ $withdraw->method->name }}</span>
                                            </td>
                                            <td>
                                                {{ formatter($withdraw->withdraw_amount, true) }}
                                            </td>
                                            <td>
                                                {{ formatter($withdraw->charge, true) }}
                                            </td>
                                            <td> {{ formatter($withdraw->getable_amount, true) }}</td>
                                            <td>
                                                <?= status($withdraw) ?>

                                            </td>
                                            @if (admin()->can('manage_withdraw'))
                                                <td>
                                                    <div class="d-flex flex-wrap align-items-center gap-2">
                                                        <button class="btn btn-icon btn-primary rounded-circle details"
                                                            data-withdraw="{{ $withdraw->id }}" data-bs-toggle="modal"
                                                            data-bs-target="#withdrawDetailsModal">
                                                            <i class="ri-eye-line"></i>
                                                        </button>

                                                    </div>
                                                </td>
                                            @endif
                                        </tr>
                                    @empty
                                        <x-no-data></x-no-data>
                                    @endforelse
                                </x-slot>

                            </x-table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-3 mt-1">

        <div class="col-xxl-3 col-lg-6 order-1">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{ tt_trans('Quick Links', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-2 position-relative">
                        <div class="d-flex align-items-center gap-2">
                            <div
                                class="card-icon bg-light-info text-info text-xxl rounded d-flex align-items-center justify-content-center flex-shrink-0">
                                <iconify-icon icon="solar:cash-out-outline"></iconify-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0 text-sm">{{ tt_trans('Deposit', cons()::LANGUAGE_BACKEND) }}</h6>
                                <p class="mb-0 text-sm">
                                    {{ tt_trans('Online and offline deposit', cons()::LANGUAGE_BACKEND) }}</p>
                            </div>
                        </div>
                        <span class="text-dark text-xl"><i class="ri-arrow-right-line"></i></span>
                        <a href="{{ route('panel.offline-deposits') }}"
                            class="position-absolute top-0 start-0 w-100 h-100"></a>
                    </div>
                    <hr>

                    <div class="d-flex align-items-center justify-content-between gap-2 position-relative">
                        <div class="d-flex align-items-center gap-2">
                            <div
                                class="card-icon bg-light-success text-success text-xxl rounded d-flex align-items-center justify-content-center flex-shrink-0">
                                <iconify-icon icon="iconoir:hand-cash"></iconify-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0 text-sm">{{ tt_trans('Withdraw', cons()::LANGUAGE_BACKEND) }}</h6>
                                <p class="mb-0 text-sm">
                                    {{ tt_trans('Withdraw Requests', cons()::LANGUAGE_BACKEND) }}
                                </p>
                            </div>
                        </div>
                        <span class="text-dark text-xl"><i class="ri-arrow-right-line"></i></span>
                        <a href="{{ route('panel.withdraw-request') }}"
                            class="position-absolute top-0 start-0 w-100 h-100"></a>
                    </div>
                    <hr>

                    <div class="d-flex align-items-center justify-content-between gap-2 position-relative">
                        <div class="d-flex align-items-center gap-2">
                            <div
                                class="card-icon bg-light-warning text-warning text-xxl rounded d-flex align-items-center justify-content-center flex-shrink-0">
                                <iconify-icon icon="heroicons:users"></iconify-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0 text-sm">{{ tt_trans('Users', cons()::LANGUAGE_BACKEND) }}</h6>
                                <p class="mb-0 text-sm">{{ tt_trans('All Users') }}</p>
                            </div>
                        </div>
                        <span class="text-dark text-xl"><i class="ri-arrow-right-line"></i></span>
                        <a href="{{ route('panel.users') }}" class="position-absolute top-0 start-0 w-100 h-100"></a>
                    </div>
                    <hr>

                    <div class="d-flex align-items-center justify-content-between gap-2 position-relative">
                        <div class="d-flex align-items-center gap-2">
                            <div
                                class="card-icon bg-light-danger text-danger text-xxl rounded d-flex align-items-center justify-content-center flex-shrink-0">
                                <iconify-icon icon="solar:settings-broken"></iconify-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0 text-sm">{{ tt_trans('Settings', cons()::LANGUAGE_BACKEND) }}</h6>
                                <p class="mb-0 text-sm">{{ tt_trans('General settings', cons()::LANGUAGE_BACKEND) }}
                                </p>
                            </div>
                        </div>
                        <span class="text-dark text-xl"><i class="ri-arrow-right-line"></i></span>
                        <a href="{{ route('panel.settings') }}" class="position-absolute top-0 start-0 w-100 h-100"></a>
                    </div>

                    <hr>

                    <div class="d-flex align-items-center justify-content-between gap-2 position-relative">
                        <div class="d-flex align-items-center gap-2">
                            <div
                                class="card-icon bg-light-danger text-danger text-xxl rounded d-flex align-items-center justify-content-center flex-shrink-0">
                                <iconify-icon icon="emojione-monotone:admission-tickets"></iconify-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0 text-sm">{{ tt_trans('Support', cons()::LANGUAGE_BACKEND) }}</h6>
                                <p class="mb-0 text-sm">{{ tt_trans('Support Tickets', cons()::LANGUAGE_BACKEND) }}
                                </p>
                            </div>
                        </div>
                        <span class="text-dark text-xl"><i class="ri-arrow-right-line"></i></span>
                        <a href="{{ route('panel.support') }}" class="position-absolute top-0 start-0 w-100 h-100"></a>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-xxl-5 col-12 order-xxl-2 order-3">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{ tt_trans('Stage Purchase Chart', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <div class="card-body overflow-hidden">
                    <div id="report-chart"></div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 col-lg-6 order-xxl-3 order-2">
            <div class="card h-100">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{ tt_trans('Users status', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <div class="card-body d-flex justify-content-center align-items-center overflow-hidden">
                    <div id="category"></div>
                </div>
            </div>
        </div>
    </div>


    <x-modal id="details" title="Deposit Details" bodyId="append">

    </x-modal>



    <x-modal id="withdrawDetailsModal" title="Withdraw Details" bodyId="appendWithdraw">

    </x-modal>
    <x-modal id="withdrawAcceptModal" size="" :isHeader="false">
        <div class="d-flex flex-column justify-content-center align-items-center">
            <div class="card-icon-lg bg-light-success text-success text-2xl item-center rounded-circle">
                <iconify-icon icon="ph:seal-check-light"></iconify-icon>
            </div>
            <h5 class="mt-4">{{ tt_trans('Withdraw accept', cons()::LANGUAGE_BACKEND) }}</h5>
            <p>{{ tt_trans('Do you really wan to accept this withdraw', cons()::LANGUAGE_BACKEND) }}?</p>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>

                <form method="post">
                    @csrf
                    <button type="submit"
                        class="btn btn-success">{{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                </form>
            </div>
        </div>
    </x-modal>

    <x-modal id="withdrawRejectModal" size="" :isHeader="false">
        <h5 class="mb-1">{{ tt_trans('Reject this withdraw', cons()::LANGUAGE_BACKEND) }}</h5>
        <p class="text-warning text-sm">
            {{ tt_trans('Do you really wan to reject this withdraw', cons()::LANGUAGE_BACKEND) }}?</p>
        <form method="post">
            @csrf
            <div class="mt-4">
                <label class="form-label">{{ tt_trans('Reason of reject', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea name="reason" class="form-control" rows="6" cols="12"></textarea>
            </div>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <button type="submit"
                    class="btn btn-danger">{{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </form>
    </x-modal>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('apexcharts.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('apexcharts.min.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {

            'use strict'

            const depositData = @json($finalDepositData);
            const withdrawData = @json($finalWithdrawData);
            const tokenData = @json($finalTokenData);
            const dates = @json($dates);
            const tokenDates = @json($tokenDates);




            var options = {
                series: [{
                        name: "Deposit",
                        data: depositData
                    },
                    {
                        name: "Withdraw",
                        data: withdrawData
                    }
                ],
                chart: {
                    toolbar: {
                        show: false
                    },
                    height: 375,
                    type: 'bar',
                    zoom: {
                        enabled: false
                    },
                    dropShadow: {
                        enabled: true,
                        enabledOnSeries: undefined,
                        top: 5,
                        left: 0,
                        blur: 3,
                        color: '#000',
                        opacity: 0.15
                    },
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '10%',
                        endingShape: 'rounded'
                    },
                },
                grid: {
                    borderColor: '#f1f1f1',
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: [2, 2],
                    curve: ['smooth', 'smooth'],
                    lineCap: 'butt',
                    dashArray: [0, 0]
                },
                title: {
                    text: undefined,
                },
                legend: {
                    show: true,
                    position: 'top',
                    horizontalAlign: 'center',
                    fontWeight: 600,
                    fontSize: '11px',
                    tooltipHoverFormatter: function(val, opts) {
                        return val + ' - ' + opts.w.globals.series[opts.seriesIndex][opts.dataPointIndex] +
                            ''
                    },
                    labels: {
                        colors: '#74767c',
                    },
                    markers: {
                        width: 7,
                        height: 7,
                        strokeWidth: 0,
                        radius: 12,
                        offsetX: 0,
                        offsetY: 0
                    },
                },
                markers: {
                    discrete: [{
                            seriesIndex: 0,
                            dataPointIndex: 5,
                            fillColor: '#305cfc',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        },
                        {
                            seriesIndex: 0,
                            dataPointIndex: 11,
                            fillColor: '#305cfc',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        },
                        {
                            seriesIndex: 1,
                            dataPointIndex: 10,
                            fillColor: '#23b7e5',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        }, {
                            seriesIndex: 1,
                            dataPointIndex: 4,
                            fillColor: '#23b7e5',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        }
                    ],
                    hover: {
                        sizeOffset: 6
                    }
                },
                yaxis: {
                    title: {
                        style: {
                            color: '#adb5be',
                            fontSize: '14px',
                            fontFamily: 'poppins, sans-serif',
                            fontWeight: 600,
                            cssClass: 'apexcharts-yaxis-label',
                        },
                    },
                    labels: {
                        formatter: function(y) {
                            return y.toFixed(0) + "";
                        },
                        show: true,
                        style: {
                            colors: "#8c9097",
                            fontSize: '11px',
                            fontWeight: 600,
                            cssClass: 'apexcharts-xaxis-label',
                        },
                    }
                },
                xaxis: {
                    type: 'day',
                    categories: dates,
                    axisBorder: {
                        show: true,
                        color: 'rgba(119, 119, 142, 0.05)',
                        offsetX: 0,
                        offsetY: 0,
                    },
                    axisTicks: {
                        show: true,
                        borderType: 'solid',
                        color: 'rgba(119, 119, 142, 0.05)',
                        width: 6,
                        offsetX: 0,
                        offsetY: 0
                    },
                    labels: {
                        rotate: -90,
                        style: {
                            colors: "#8c9097",
                            fontSize: '11px',
                            fontWeight: 600,
                            cssClass: 'apexcharts-xaxis-label',
                        },
                    }
                },
                tooltip: {
                    y: [{
                            title: {
                                formatter: function(val) {
                                    return val
                                }
                            }
                        },
                        {
                            title: {
                                formatter: function(val) {
                                    return val
                                }
                            }
                        },
                        {
                            title: {
                                formatter: function(val) {
                                    return val;
                                }
                            }
                        }
                    ]
                },
                colors: ["var(--primary)", "var(--info)"],
            };
            document.querySelector("#depositOverview").innerHTML = " ";
            var chart1 = new ApexCharts(document.querySelector("#depositOverview"), options);
            chart1.render();

            var options = {
                series: [{
                    name: "Tokens",
                    data: tokenData
                }],
                chart: {
                    toolbar: {
                        show: false
                    },
                    height: 305,
                    type: 'bar',
                    zoom: {
                        enabled: false
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '10%',
                        endingShape: 'rounded'
                    },
                },
                grid: {
                    borderColor: '#f1f1f1',
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: [2, 2],
                    curve: ['smooth', 'smooth'],
                    lineCap: 'butt',
                    dashArray: [0, 0]
                },
                title: {
                    text: undefined,
                },
                legend: {
                    show: true,
                    position: 'top',
                    horizontalAlign: 'center',
                    fontWeight: 600,
                    fontSize: '11px',
                    tooltipHoverFormatter: function(val, opts) {
                        return val + ' - ' + opts.w.globals.series[opts.seriesIndex][opts.dataPointIndex] +
                            ''
                    },
                    labels: {
                        colors: '#74767c',
                    },
                    markers: {
                        width: 7,
                        height: 7,
                        strokeWidth: 0,
                        radius: 12,
                        offsetX: 0,
                        offsetY: 0
                    },
                },
                markers: {
                    discrete: [{
                            seriesIndex: 0,
                            dataPointIndex: 5,
                            fillColor: '#305cfc',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        },
                        {
                            seriesIndex: 0,
                            dataPointIndex: 11,
                            fillColor: '#305cfc',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        },
                        {
                            seriesIndex: 1,
                            dataPointIndex: 10,
                            fillColor: '#23b7e5',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        }, {
                            seriesIndex: 1,
                            dataPointIndex: 4,
                            fillColor: '#23b7e5',
                            strokeColor: '#fff',
                            size: 4,
                            shape: "circle"
                        }
                    ],
                    hover: {
                        sizeOffset: 6
                    }
                },
                yaxis: {
                    title: {
                        style: {
                            color: '#adb5be',
                            fontSize: '14px',
                            fontFamily: 'poppins, sans-serif',
                            fontWeight: 600,
                            cssClass: 'apexcharts-yaxis-label',
                        },
                    },
                    labels: {
                        formatter: function(y) {
                            return y;
                        },
                        show: true,
                        style: {
                            colors: "#8c9097",
                            fontSize: '11px',
                            fontWeight: 600,
                            cssClass: 'apexcharts-xaxis-label',
                        },
                    }
                },
                xaxis: {
                    type: 'day',
                    categories: tokenDates,
                    axisBorder: {
                        show: true,
                        color: 'rgba(119, 119, 142, 0.05)',
                        offsetX: 0,
                        offsetY: 0,
                    },
                    axisTicks: {
                        show: true,
                        borderType: 'solid',
                        color: 'rgba(119, 119, 142, 0.05)',
                        width: 6,
                        offsetX: 0,
                        offsetY: 0
                    },
                    labels: {
                        rotate: -90,
                        style: {
                            colors: "#8c9097",
                            fontSize: '11px',
                            fontWeight: 600,
                            cssClass: 'apexcharts-xaxis-label',
                        },
                    }
                },
                tooltip: {
                    y: [{
                            title: {
                                formatter: function(val) {
                                    return val
                                }
                            }
                        },
                        {
                            title: {
                                formatter: function(val) {
                                    return val
                                }
                            }
                        },
                        {
                            title: {
                                formatter: function(val) {
                                    return val;
                                }
                            }
                        }
                    ]
                },
                colors: ["var(--primary)", "var(--info)"],
            };
            document.querySelector("#report-chart").innerHTML = " ";
            var chart2 = new ApexCharts(document.querySelector("#report-chart"), options);
            chart2.render();





            $('.details').on('click', function() {
                $.ajax({
                    method: "GET",
                    url: $(this).data('action'),
                    success: function(response) {
                        $('#append').html(response)
                    }
                })
            })


            $('.details').on('click', function() {
                $.ajax({
                    method: "GET",
                    url: "{{ route('panel.withdraw-details') }}",
                    data: {
                        withdraw: $(this).data('withdraw')
                    },
                    success: function(response) {
                        $('#appendWithdraw').html(response)
                    }
                })
            })

            $('.accept').on('click', function() {
                $('#withdrawAcceptModal').find('form').attr('action', $(this).data('action'))
            })

            $('.reject').on('click', function() {
                $('#withdrawRejectModal').find('form').attr('action', $(this).data('action'))
            })


            // category overview

            var totalUsers = {{ $total_users }};
            var activeUsers = {{ $active_users }};
            var inactiveUsers = {{ $inactive_users }};
            var emailUnverifiedUsers = {{ $email_unverified_users }};

            // Ensure all values are valid percentages
            var seriesData = [
                (activeUsers / totalUsers) * 100,
                (inactiveUsers / totalUsers) * 100,
                (emailUnverifiedUsers / totalUsers) * 100
            ];

            // If all users are active, adjust the chart to show 100% for "Active Users"
            if (inactiveUsers === 0 && emailUnverifiedUsers === 0) {
                seriesData = [100, 0, 0];
            }

            var options3 = {
                series: seriesData,
                chart: {
                    height: 350,
                    type: 'radialBar',
                },
                plotOptions: {
                    radialBar: {
                        dataLabels: {
                            name: {
                                fontSize: '22px',
                            },
                            value: {
                                fontSize: '16px',
                            },
                            total: {
                                show: true,
                                label: 'Total',
                                formatter: function(w) {
                                    return totalUsers; // Return the total user count
                                }
                            }
                        }
                    }
                },
                labels: ['Active Users', 'Inactive Users', 'Email Unverified'],
            };

            var chart3 = new ApexCharts(document.querySelector("#category"), options3);
            chart3.render();

        })
    </script>
@endpush
