@extends('backend.layouts.master')

@section('panel')
    <div class="row justify-content-center">
        <div class="col-xl-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                        <h4 class="card-title mb-0">
                            {{ tt_trans('Deposit Information', cons()::LANGUAGE_BACKEND) }}

                            @if ($deposit->status == cons()::PENDING)
                                <span class="badge badge-warning" data-bs-toggle="tooltip" data-bs-title="Deposit Pending">
                                    <i class="ri-loader-line"></i>
                                    {{ tt_trans('Pending', cons()::LANGUAGE_BACKEND) }}
                                </span>
                            @elseif($deposit->status == cons()::ACCEPTED)
                                <span class="badge badge-success" data-bs-toggle="tooltip" data-bs-title="Deposit success">
                                    <i class="ri-check-double-line"></i>
                                    {{ tt_trans('Accepted', cons()::LANGUAGE_BACKEND) }}
                                </span>
                            @else
                                <span class="badge badge-danger" data-bs-toggle="tooltip" data-bs-title="Deposit Rejected">
                                    <i class="ri-close-line"></i>
                                    {{ tt_trans('Rejected', cons()::LANGUAGE_BACKEND) }}
                                </span>
                            @endif

                        </h4>
                        @if ($deposit->status == cons()::PENDING)
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal"
                                    data-bs-target="#accept"><i class="ri-check-line"></i>
                                    {{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                    data-bs-target="#reject"><i class="ri-close-line"></i>
                                    {{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="pt-3">
                        <div class="row gy-4 mb-5">
                            @foreach ($deposit->method->parameters->proof as $setting)
                                @if ($setting->field_type != 'file' && isset($deposit->proof[$setting->field_name]))
                                    <div class="col-sm-6">
                                        <span class="text-sm text-muted">{{ $setting->label_name }}</span>
                                        <p class="mb-0 fw-semibold display-color">
                                            {{ $deposit->proof[$setting->field_name] }}
                                        </p>
                                    </div>
                                @endif
                            @endforeach
                        </div>

                        <div class="row gy-4">
                            @foreach ($deposit->method->parameters->proof as $setting)
                                @if ($setting->field_type == 'file' && isset($deposit->proof[$setting->field_name]))
                                    <div class="col-sm-4">
                                        <p class="mb-2">{{ $setting->label_name }}</p>
                                        <img src="{{ getFile('deposit', $deposit->proof[$setting->field_name]) }}"
                                            alt="image" class="rounded-3">
                                        <a href="{{ getFile('deposit', $deposit->proof[$setting->field_name]) }}"
                                            class="image-view btn btn-sm btn-primary w-100 text-center mt-3">
                                            {{ tt_trans('View Image', cons()::LANGUAGE_BACKEND) }}
                                        </a>
                                    </div>
                                @endif
                            @endforeach


                            @if ($deposit->status == cons()::REJECTED)
                            <div class="col-sm-4">
                                    <span>{{ tt_front('Reason of rejection', cons()::LANGUAGE_BACKEND) }}</span>
                                    <span class="fw-semibold">{{ $deposit->reason }}</span>
                                </div>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <x-modal id="accept" title="Accept Deposit Request" size="">
        <div class="d-flex flex-column justify-content-center align-items-center text-center">
            <div class="card-icon-lg bg-light-danger text-danger text-2xl item-center rounded-circle">
                <iconify-icon icon="ant-design:alert-outlined"></iconify-icon>
            </div>
            <h5 class="mt-4">{{ tt_trans('Are You Sure', cons()::LANGUAGE_BACKEND) }}?</h5>
            <p class="text-muted mb-0">{{ tt_trans('This will', cons()::LANGUAGE_BACKEND) }} <span
                    class="text-danger">{{ tt_trans('Verify Deposit request', cons()::LANGUAGE_BACKEND) }}</span>.
                {{ tt_trans("You can't undo this action.", cons()::LANGUAGE_BACKEND) }}.
            </p>

            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <form action="{{ route('panel.offline-deposit-accept', $deposit->id) }}" method="post">
                    @csrf
                    <button type="submit"
                        class="btn btn-success">{{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                </form>
            </div>


        </div>



    </x-modal>



    <x-modal id="reject" title="Reject Deposit Request" size="" :isHeader="false">
        <form action="{{ route('panel.offline-deposit-reject', $deposit->id) }}" method="post">
            @csrf
            <h5 class="mb-1">{{ tt_trans('Deny this deposit', cons()::LANGUAGE_BACKEND) }}</h5>
            <p class="text-warning text-sm">
                {{ tt_trans('Do you really wan to reject this deposit', cons()::LANGUAGE_BACKEND) }}?</p>
            <div class="mt-4">
                <label class="form-label">{{ tt_trans('Reason of reject', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea name="reason" class="form-control" rows="6" cols="12"></textarea>
            </div>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <button type="submit" class="btn btn-danger">{{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </form>

    </x-modal>
@endsection

@push('script')
    <link rel="stylesheet" href="{{ css('magnific-popup.css') }}">
@endpush

@push('script')
    <script src="{{ js('magnifc-popup.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            'use strict'
            $('.image-view').magnificPopup({
                type: 'image'
            });

        });
    </script>
@endpush
