@extends('backend.layouts.master')
@section('panel')

    <div class="row gy-4">
        <div class="col-xl-8">
            <div class="card">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                    <h4 class="card-title mb-0">{{ $template->name }}</h4>

                    <div>
                        <input class="toggle-one changeStatus" {{ $template->status ? 'checked' : '' }} type="checkbox"
                            data-on="Active" data-off="Disable" data-onstyle="success" data-offstyle="danger" data-width="100">
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">{{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="subject" class="form-control" placeholder="Enter Subject"
                                value="{{ $template->subject }}">
                        </div>

                        <div class="mb-3 summer-note-form">
                            <label class="form-label">{{ tt_trans('Template', cons()::LANGUAGE_BACKEND) }}</label>
                            <textarea name="message" class="summernote">
                                <?= $template->message ?>
                            </textarea>
                        </div>
                        <div class="text-end mt-4">
                            <button
                                class="btn btn-primary">{{ tt_trans('Update Template', cons()::LANGUAGE_BACKEND) }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <div class="col-xl-4">
            <div class="card h-100">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{ tt_trans('Email Short Code', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li
                            class="list-group-item d-flex align-items-center justify-content-between gap-2 text-sm bg-light">
                            <span class="fw-semibold">{{ tt_trans('Description', cons()::LANGUAGE_BACKEND) }}</span>
                            <span class="fw-semibold">{{ tt_trans('Short Code', cons()::LANGUAGE_BACKEND) }}</span>
                        </li>
                        @if ($setting['codes'])
                            @foreach ($setting['codes'] as $key => $code)
                                <li class="list-group-item d-flex align-items-center justify-content-between gap-2 text-sm">
                                    <span>{{ tt_trans($code, cons()::LANGUAGE_BACKEND) }}</span>
                                    <span>{{ '{' . $key . '}' }}</span>
                                </li>
                            @endforeach
                        @endif

                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(document).ready(function() {

            'use strict'

            $('.toggle-one').bootstrapToggle();


            $('.changeStatus').on('change', function() {
                changeStatus('Template', 'status', "{{ $template->id }}");
            })

            $('[data-toggle="dropdown"]').each(function() {
                $(this).attr('data-bs-toggle', 'dropdown');
                $(this).removeAttr('data-toggle');
            });
        });
    </script>
@endpush
