@extends('backend.layouts.master')
@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <div>
                <h4 class="card-title mb-0">{{ tt_trans('SMTP Configuration', cons()::LANGUAGE_BACKEND) }}</h4>
                <p class="text-xs text-muted mb-0">
                    {{ tt_trans('If smtp is disable, php mail is auto active.', cons()::LANGUAGE_BACKEND) }}</p>
            </div>
            <div>
                <input class="toggle-one changeStatus" {{ tc()->get('is_smtp_mail') ? 'checked' : '' }} type="checkbox"
                    data-on="Active" data-off="Disable" data-onstyle="success" data-offstyle="danger" data-width="100">
            </div>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                @csrf
                <div class="row gy-3">
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Email sent from', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="email" name="email_configurations[email_from]" class="form-control"
                            placeholder="{{tt_trans('Enter Mail Address',cons()::LANGUAGE_BACKEND)}}"
                            value="{{ tc()->get('email_configurations')['email_from'] ?? '' }}">
                    </div>
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Smtp host', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="email_configurations[host]" class="form-control"
                            placeholder="{{ tt_trans('Enter Smtp Host',cons()::LANGUAGE_BACKEND)}}" value="{{ tc()->get('email_configurations')['host'] ?? '' }}">
                    </div>
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Smtp username', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="email_configurations[username]" class="form-control"
                            placeholder="{{ tt_trans('Enter Smtp Username',cons()::LANGUAGE_BACKEND)}}"
                            value="{{ tc()->get('email_configurations')['username'] ?? '' }}">
                    </div>
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Smtp password', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="email_configurations[password]" class="form-control"
                            placeholder="{{ tt_trans('Enter Smtp Password',cons()::LANGUAGE_BACKEND) }}"
                            value="{{ tc()->get('email_configurations')['password'] ?? '' }}">
                    </div>
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Smtp port', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="email_configurations[port]" class="form-control"
                            placeholder="{{ tt_trans('Enter Smtp Port',cons()::LANGUAGE_BACKEND)}}" value="{{ tc()->get('email_configurations')['port'] ?? '' }}">
                    </div>
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Smtp encryption', cons()::LANGUAGE_BACKEND) }}</label>
                        <select name="email_configurations[encryption]" class="form-select">
                            <option value="ssl"
                                {{ selectedOption(tc()->get('email_configurations')['encryption'] ?? '' == 'ssl') }}>
                                {{ tt_trans('SSL', cons()::LANGUAGE_BACKEND) }}</option>
                            <option value="tls"
                                {{ selectedOption(tc()->get('email_configurations')['encryption'] ?? '' == 'tls') }}>
                                {{ tt_trans('TLS', cons()::LANGUAGE_BACKEND) }}</option>
                        </select>
                    </div>
                    <div class="col-lg-12">
                        <button type="submit"
                            class="btn btn-primary">{{ tt_trans('Update Email Configuration', cons()::LANGUAGE_BACKEND) }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header d-flex flex-wrap gap-2 align-items-center justify-content-between">
            <h4 class="card-title mb-0">{{ tt_trans('All Email Templates', cons()::LANGUAGE_BACKEND) }}</h4>

        </div>
        <div class="card-body">
            <x-table :paginations="$templates">
                <tr>
                    <th scope="col"><i class="ri-profile-line"></i> {{ tt_trans('Name', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-file-list-3-line"></i>
                        {{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse ($templates as $template)
                        @php
                            $setting = mailTemplate($template->key);
                        @endphp
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <div
                                        class="avatar-lg {{ $setting['display']['color'] ?? 'bg-info' }} text-white item-center rounded-circle text-xxl">
                                        <iconify-icon
                                            icon="{{ $setting['display']['icon'] ?? 'akar-icons:percentage' }}"></iconify-icon>
                                    </div>
                                    <div>
                                        <h6 class="text-sm mb-1">{{ tt_trans($template->name,cons()::LANGUAGE_BACKEND) }}</h6>
                                        <p class="text-xs mb-0 line-height-1 text-muted">
                                            {{ tt_trans('Created at', cons()::LANGUAGE_BACKEND) }}
                                            {{ dateFormatter($template->created_at) }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <p class="mb-0">{{ tt_trans($template->subject) }}</p>
                            </td>
                            <td>
                                <?= status($template) ?>
                            </td>
                            <td>
                                <a href="{{ route('panel.email.template', $template->key) }}"
                                    class="btn btn-icon btn-primary rounded-circle">
                                    <i class="ri-edit-line"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse

                </x-slot>
            </x-table>


        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'


            $('.toggle-one').bootstrapToggle();

            $('.changeStatus').on('change', function() {
                changeStatus('Setting', 'is_smtp_mail', "{{ tc()->get('id') }}");
            })



            $('#loadContent').on('click', function() {
                $.ajax({
                    url: "{{ route('panel.email-global-template-load') }}",
                    type: 'GET',
                    success: function(response) {
                        $('.nicEdit-main').html(response);
                    },
                    error: function(xhr) {
                        console.log('Error loading content: ', xhr);
                    }
                });
            });



        });
    </script>
@endpush
