@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ $gateway->name }} {{ tt_trans('Settings', cons()::LANGUAGE_BACKEND) }}</h4>
            <a href="{{ route('panel.gateways') }}" class="btn btn-sm btn-light"><i
                    class="ri-arrow-left-line"></i>{{ tt_trans('Back', cons()::LANGUAGE_BACKEND) }}</a>
        </div>
        <div class="card-body">
            <form method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-3">
                    <div class="col-lg-12">
                        <label class="form-label mb-2">{{ tt_trans('Gateway image', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="image-upload">
                            <div class="image-preview">
                                <div class="singleImage"
                                    style="background-image: url({{ getFile('gateways', $gateway->image) }});"
                                    class="bg-size-contain">
                                </div>
                            </div>
                            <div class="image-edit-btn">
                                <input type='file' name="image" id="image1" class="singleImageUpload"
                                    accept=".png, .jpg, .jpeg" />
                                <label for="image1" data-text="Upload"></label> <!-- data-text translate hobe -->
                            </div>
                        </div>
                    </div>

                    @if ($gateway->name == 'paypal')
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Mode', cons()::LANGUAGE_BACKEND) }}</label>
                            <select name="parameters[mode]" class="from-select form-control">
                                <option value="live" {{ selectedOption($gateway->parameters?->mode == 'live') }}>
                                    {{ tt_trans('LIVE', cons()::LANGUAGE_BACKEND) }}</option>
                                <option value="sandbox" {{ selectedOption($gateway->parameters?->mode == 'sandbox') }}>
                                    {{ tt_trans('SANDBOX', cons()::LANGUAGE_BACKEND) }}</option>
                            </select>

                        </div>

                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Client ID', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[client_id]" class="form-control"
                                placeholder="{{ tt_back('Enter Client Id') }}"
                                value="{{ $gateway->parameters?->client_id }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Client Secret', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[client_secret]" class="form-control"
                                placeholder="{{ tt_back('Enter client secret') }}"
                                value="{{ $gateway->parameters?->client_secret }}">
                        </div>
                    @elseif($gateway->name == 'stripe')
                        <div class="col-lg-6">
                            <label
                                class="form-label">{{ tt_trans('Stripe publishable key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[publish_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Publishable Key') }}"
                                value="{{ $gateway->parameters?->publish_key }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Stripe secret key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[secret_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Secret Key') }}"
                                value="{{ $gateway->parameters?->secret_key }}">
                        </div>
                    @elseif($gateway->name == 'paytm')
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Mode', cons()::LANGUAGE_BACKEND) }}</label>
                            <select name="parameters[mode]" class="from-select form-control">
                                <option value="live" {{ selectedOption($gateway->parameters?->mode == 'live') }}>
                                    {{ tt_trans('LIVE', cons()::LANGUAGE_BACKEND) }}</option>
                                <option value="sandbox" {{ selectedOption($gateway->parameters?->mode == 'sandbox') }}>
                                    {{ tt_trans('SANDBOX', cons()::LANGUAGE_BACKEND) }}</option>
                            </select>

                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Merchant Id', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[merchant_id]" class="form-control"
                                placeholder="{{ tt_back('Enter merchant id') }}"
                                value="{{ $gateway->parameters?->merchant_id }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Merchant key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[merchant_key]" class="form-control"
                                placeholder="{{ tt_back('Enter merchant key') }}"
                                value="{{ $gateway->parameters?->merchant_key }}">
                        </div>
                    @elseif($gateway->name == 'flutterwave')
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Public key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[public_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Public key') }}"
                                value="{{ $gateway->parameters?->public_key }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Secret key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[secret_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Secret Key') }}"
                                value="{{ $gateway->parameters?->secret_key }}">
                        </div>
                    @elseif($gateway->name == 'perfectmoney')
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Account id', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[account_id]" class="form-control"
                                placeholder="{{ tt_back('Enter account id') }}"
                                value="{{ $gateway->parameters?->account_id }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Passphrase', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[passphrase]" class="form-control"
                                placeholder="{{ tt_back('Enter passphrase') }}"
                                value="{{ $gateway->parameters?->passphrase }}">
                        </div>
                    @elseif($gateway->name == 'paystack')
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Callback Url', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[callback_url]" class="form-control"
                                placeholder="{{ tt_back('Enter Callback Url') }}"
                                value="{{ $gateway->parameters?->callback_url }}">
                        </div>

                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Public key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[public_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Public key') }}"
                                value="{{ $gateway->parameters?->public_key }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Secret key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[secret_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Secret Key') }}"
                                value="{{ $gateway->parameters?->secret_key }}">
                        </div>

                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Merchant Email', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[merchant_email]" class="form-control"
                                placeholder="{{ tt_back('Enter Merchant Email') }}"
                                value="{{ $gateway->parameters?->merchant_email }}">
                        </div>
                    @elseif($gateway->name == 'coinpayment')
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Public key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[public_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Public Key') }}"
                                value="{{ $gateway->parameters?->public_key }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Private Key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[private_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Private Key') }}"
                                value="{{ $gateway->parameters?->private_key }}">
                        </div>
                    @elseif($gateway->name == '2checkout')
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Publishable Key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[publishable_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Publishable Key') }}"
                                value="{{ $gateway->parameters?->publishable_key }}">
                        </div>
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Private Key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[private_key]" class="form-control"
                                placeholder="{{ tt_back('Enter Private Key') }}"
                                value="{{ $gateway->parameters?->private_key }}">
                        </div>
                    @elseif($gateway->name == 'nowpayments')
                        <div class="col-lg-6">
                            <label
                                class="form-label">{{ tt_trans('Nowpayment api key', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[api_key]" class="form-control"
                                placeholder="{{ tt_back('Enter api key') }}"
                                value="{{ $gateway->parameters?->api_key }}">
                        </div>

                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Nowpayment mode', cons()::LANGUAGE_BACKEND) }}</label>
                            <select name="parameters[mode]" class="form-select">
                                <option value="live" {{ selectedOption($gateway->parameters?->mode == 'live') }}>
                                    {{ tt_trans('Live', cons()::LANGUAGE_BACKEND) }}</option>
                                <option value="sandbox" {{ selectedOption($gateway->parameters?->mode == 'sandbox') }}>
                                    {{ tt_trans('Sandbox', cons()::LANGUAGE_BACKEND) }}</option>
                            </select>

                        </div>
                    @else
                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Mode', cons()::LANGUAGE_BACKEND) }}</label>
                            <select name="parameters[mode]" class="from-select form-control">
                                <option value="live" {{ selectedOption($gateway->parameters?->mode == 'live') }}>
                                    {{ tt_trans('LIVE', cons()::LANGUAGE_BACKEND) }}</option>
                                <option value="sandbox" {{ selectedOption($gateway->parameters?->mode == 'sandbox') }}>
                                    {{ tt_trans('SANDBOX', cons()::LANGUAGE_BACKEND) }}</option>
                            </select>

                        </div>


                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Store Id', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[store_id]" class="form-control"
                                placeholder="{{ tt_back('Enter store Id') }}"
                                value="{{ $gateway->parameters?->store_id }}">
                        </div>


                        <div class="col-lg-6">
                            <label class="form-label">{{ tt_trans('Store Password', cons()::LANGUAGE_BACKEND) }}</label>
                            <input type="text" name="parameters[store_password]" class="form-control"
                                placeholder="{{ tt_back('Enter store password') }}"
                                value="{{ $gateway->parameters?->store_password }}">
                        </div>
                    @endif

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Gateway currency', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="currency" class="form-control currency"
                            placeholder="{{ tt_back('Enter Currency') }}" value="{{ $gateway->currency }}">
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Charge', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="number" step="any" name="charge" class="form-control"
                            placeholder="{{ tt_back('Enter Method Charge') }}"
                            value="{{ formatter($gateway->charge) }}">
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Charge Type', cons()::LANGUAGE_BACKEND) }}</label>
                        <select name="type" class="form-select">
                            <option value="{{ cons()::FIXED }}" {{ selectedOption($gateway->type == cons()::FIXED) }}>
                                {{ tt_trans('Fixed', cons()::LANGUAGE_BACKEND) }}</option>
                            <option value="{{ cons()::PERCENTAGE }}"
                                {{ selectedOption($gateway->type == cons()::PERCENTAGE) }}>
                                {{ tt_trans('Percentage', cons()::LANGUAGE_BACKEND) }}
                            </option>
                        </select>
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Conversion rate', cons()::LANGUAGE_BACKEND) }} <sup
                                class="text-danger">*</sup></label>
                        <div class="input-group">
                            <span class="input-group-text text-sm">1 {{ tc()->get('currency') }} = </span>
                            <input type="text" class="form-control" name="rate"
                                placeholder="{{ tt_back('Enter conversion rate') }}" value="{{ $gateway->rate }}">
                            <span class="input-group-text text-sm currencyAppear">{{ $gateway->currency }}</span>
                        </div>
                    </div>
                    <div class="col-12">
                        <button type="submit"
                            class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('.currency').on('keyup', function() {
                $('.currencyAppear').text($(this).val())
            })
        })
    </script>
@endpush
