@extends('backend.layouts.master')

@section('panel')
    <div class="row g-4">
        @foreach ($gateways as $gateway)
            <div class="col-xxl-6">
                <div class="card p-3">
                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                        <div class="d-flex flex-wrap gap-3 align-items-center">
                            <img src="{{ getFile('gateways', $gateway->image, '100x40') }}" alt="image" class="gateway-img">
                            <div>
                                <h6 class="mb-0 text-md">{{ $gateway->name }} </h6>
                                <div class="mt-1">
                                    <span class="badge badge-light">{{ tt_trans('Currency', cons()::LANGUAGE_BACKEND) }} :
                                        {{ $gateway->currency }}</span>
                                    <span class="badge badge-light">{{ tt_trans('Rate', cons()::LANGUAGE_BACKEND) }} :

                                        {{ true ? formatter($gateway->rate) . ' ' . $gateway->currency : $gateway->rate.' '.$gateway->currency  }}
                                    </span>
                                    <?= status($gateway, 'light-') ?>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex flex-wrap gap-2">
                            <a href="{{ route('panel.gateway.edit', $gateway->id) }}"
                                class="btn btn-sm btn-light-primary"><i
                                    class="ri-edit-line"></i>{{ tt_trans('Edit', cons()::LANGUAGE_BACKEND) }}</a>

                            <div>
                                <input class="toggle-one changeStatus" {{ $gateway->status ? 'checked' : '' }}
                                    data-method="{{ $gateway->id }}" type="checkbox" data-on="Active" data-off="Disable"
                                    data-onstyle="success" data-offstyle="danger" data-width="100">
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        @endforeach

        @if (request()->routeIs('panel.offline-gateways'))
            <div class="col-xxl-6">
                <div class="card p-3 py-4 border border-2 border-dashed border-light-primary position-relative">
                    <a href="{{route('panel.offline-gateway-create')}}" class="position-absolute z-1 top-0 start-0 w-100 h-100"></a>
                    <div class=" d-flex flex-wrap align-items-center justify-content-center gap-3">
                        <span class="text-primary text-2xxl"><iconify-icon
                                icon="mynaui:credit-card-plus"></iconify-icon></span>
                        <h6 class="mb-0 text-primary">{{tt_trans('Add Payment Gateway',cons()::LANGUAGE_BACKEND)}}</h6>
                    </div>
                </div>
            </div>
        @endif

    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('.toggle-one').bootstrapToggle();

            $('.changeStatus').on('change', function() {
                changeStatus('Gateway', 'status', $(this).data('method'));

            })
        })
    </script>
@endpush
