@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans('Create Gateway', cons()::LANGUAGE_BACKEND) }}</h4>
            <a href="{{ route('panel.offline-gateways') }}" class="btn btn-sm btn-light"><i
                    class="ri-arrow-left-line"></i>{{ tt_trans('Back', cons()::LANGUAGE_BACKEND) }}</a>
        </div>
        <div class="card-body">
            <form method="POST" action="" enctype="multipart/form-data">
                @csrf
                <div class="row g-3">
                    <div class="col-lg-12">
                        <label class="form-label mb-2">{{ tt_trans('Gateway image', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="image-upload">
                            <div class="image-preview">
                                <div style="background-image: url({{ getFile('', '') }});"
                                    class="bg-size-contain singleImage">
                                </div>
                            </div>
                            <div class="image-edit-btn">
                                <input type='file' name="image" id="image1" class="singleImageUpload"
                                    accept=".png, .jpg, .jpeg" />
                                <label for="image1" data-text="Upload"></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Currency Type', cons()::LANGUAGE_BACKEND) }}</label>
                        <select name="currency_type" class="form-select type">
                            <option value="{{ cons()::FIAT }}">{{ tt_trans('Fiat', cons()::LANGUAGE_BACKEND) }}</option>
                            <option value="{{ cons()::CRYPTO }}">{{ tt_trans('Crypto', cons()::LANGUAGE_BACKEND) }}
                            </option>
                        </select>
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Gateway Name', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="name" class="form-control" placeholder="Enter gateway name"
                            value="{{ old('name') }}">
                    </div>

                    <div class="col-md-12" id="append">

                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Gateway currency', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="currency" class="form-control currency" placeholder="Enter Currency"
                            value="{{ old('currency') }}">
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Charge', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="input-group">
                            <input type="number" step="any" name="charge" class="form-control"
                                placeholder="Enter Method Charge" value="{{ old('charge') }}">
                            <select name="type" class="form-select">
                                <option value="{{ cons()::FIXED }}">
                                    {{ tt_trans('Fixed', cons()::LANGUAGE_BACKEND) }}</option>
                                <option value="{{ cons()::PERCENTAGE }}">
                                    {{ tt_trans('Percentage', cons()::LANGUAGE_BACKEND) }}
                                </option>
                            </select>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Conversion rate', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="input-group">
                            <span class="input-group-text text-sm">1 {{ tc()->get('currency') }} = </span>
                            <input type="text" name="rate" class="form-control" placeholder="Enter conversion rate"
                                value="{{ old('rate') }}">
                            <span class="input-group-text text-sm currencyAppear">{{ tc()->get('currency') }}</span>
                        </div>
                    </div>

                    <div class="col-lg-12 summer-note-form">
                        <label class="form-label">{{ tt_trans('Gateway Details', cons()::LANGUAGE_BACKEND) }}</label>
                        <textarea name="parameters[details]" class="summernote">{{ old('parameters.details') }}</textarea>
                    </div>

                    <div class="col-12">
                        <h4 class="card-title my-4">
                            {{ tt_trans('Payment verification requirements', cons()::LANGUAGE_BACKEND) }}</h4>

                        <div class="row gy-3" id="allRequirement">

                            <div class="col-12 single-requirement">
                                <div class="row g-3 align-items-end">
                                    <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Label name', cons()::LANGUAGE_BACKEND) }}
                                        </label>
                                        <input type="text" name="parameters[proof][0][label_name]" class="form-control"
                                            placeholder="Enter Label Name">
                                    </div>


                                    <div class="col-xxl-3 col-lg-6 col-12">
                                        <label class="form-label">{{ tt_trans('Field name', cons()::LANGUAGE_BACKEND) }}

                                            <span class="error usernameError"></span>
                                        </label>
                                        <input type="text" name="parameters[proof][0][field_name]"
                                            class="form-control valid" placeholder="Enter Field Name">
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Field type', cons()::LANGUAGE_BACKEND) }}
                                        </label>
                                        <select class="form-select" name="parameters[proof][0][field_type]">
                                            @foreach (cons()->inputTypes as $key => $types)
                                                <option value="{{ $key }}">{{ $types }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label
                                            class="form-label">{{ tt_trans('Field validation', cons()::LANGUAGE_BACKEND) }}
                                        </label>
                                        <select class="form-select" name="parameters[proof][0][validation]">
                                            @foreach (cons()->validations as $key => $validation)
                                                <option value="{{ $key }}">{{ $validation }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <button type="button" id="addRequirement" class="btn btn-primary text-lg"><i
                                                class="ri-add-line"></i></button>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>



                    <div class="col-12">
                        <button type="submit"
                            class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            let indexKyc = 1;

            $('#addRequirement').on('click', function() {
                $('#allRequirement').append(`
                <div class="col-12 single-requirement">
                    <div class="row g-3 align-items-end">
                       <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Label name', cons()::LANGUAGE_BACKEND) }}
                                            </label>
                                        <input type="text" name="parameters[proof][${indexKyc}][label_name]" class="form-control"
                                            placeholder="Enter Label Name">
                                    </div>

                                    <div class="col-xxl-3 col-lg-6 col-12">
                                        <label class="form-label">{{ tt_trans('Field name', cons()::LANGUAGE_BACKEND) }}

                                            <span class="error usernameError"></span>
                                        </label>
                                        <input type="text" name="parameters[proof][${indexKyc}][field_name]" class="form-control valid"
                                            placeholder="Enter Field Name">
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Field type', cons()::LANGUAGE_BACKEND) }}
                                            </label>
                                        <select class="form-select" name="parameters[proof][${indexKyc}][field_type]">
                                            @foreach (cons()->inputTypes as $key => $types)
                                                <option value="{{ $key }}">{{ $types }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label
                                            class="form-label">{{ tt_trans('Field validation', cons()::LANGUAGE_BACKEND) }}
                                            </label>
                                        <select class="form-select" name="parameters[proof][${indexKyc}][validation]">
                                            @foreach (cons()->validations as $key => $validation)
                                                <option value="{{ $key }}">{{ $validation }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                        <div class="col-auto">
                            <button type="button" class="btn btn-danger delete text-lg"><i class="ri-close-line"></i></button>
                        </div>
                    </div>
                </div>
            `);

                indexKyc++;

            });

            $(document).on('click', '.delete', function() {
                $(this).closest('.single-requirement').remove();
            });


            $('.currency').on('keyup', function() {
                $('.currencyAppear').text($(this).val())
            })

            let crypto = `
                <div class="row align-items-end">
                    <div class="col-auto flex-grow-1">
                        <label class="form-label">{{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" required name="parameters[sending_options][0][title]" class="form-control"
                            value="">
                    </div>

                    <div class="col-auto flex-grow-1">
                        <label class="form-label">{{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" required name="parameters[sending_options][0][value]" class="form-control"
                            value="">
                    </div>

                    <div class="col-auto">
                         <button type="button" class="btn btn-primary text-lg add"><i class="ri-add-line"></i></button>
                    </div>
                </div>
            `;

            let qr = `
                <div class="col-lg-12" id="crypto">
                        <label class="form-label">{{ tt_trans('Qr Code', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="file" name="parameters[sending_options][qr_code]" class="form-control">
                </div>
            `;

            $(document).on('click', '.add', function(e) {
                e.preventDefault();

                const container = $('#append');
                const currentRows = container.find('.row');
                const newIndex = currentRows.length;
                const newRow = `
                        <div class="row align-items-end mb-3">
                            <div class="col-auto flex-grow-1">
                                <label class="form-label">{{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</label>
                                <input type="text" required name="parameters[sending_options][${newIndex}][title]" class="form-control" value="">
                            </div>
                            <div class="col-auto flex-grow-1">
                                <label class="form-label">{{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</label>
                                <input type="text" required name="parameters[sending_options][${newIndex}][value]" class="form-control" value="">
                            </div>
                            <div class="col-auto">
                                <button type="button" class="btn btn-danger text-lg remove"><i class="ri-close-line"></i></button>
                            </div>
                        </div>
                `;

                container.append(newRow);
            });

            $(document).on('click', '.remove', function(e) {
                e.preventDefault();
                $(this).closest('.row').remove();
            });

            function generateForm($value) {
                if ($value === 'fiat') {
                    $('#append').html(crypto);
                } else {
                    $('#append').html(qr);
                }
            }

            generateForm($('.type option:selected').val())

            $('.type').on('change', function() {
                generateForm($(this).val())

            })


            $(document).on('keyup', '.valid', function(event) {
                var pattern = /^[a-zA-Z0-9]+$/;
                var isValid = true;
                $('.valid').each(function(index) {
                    var inputVal = $(this).val();

                    var sanitizedVal = inputVal.replace(/[^a-zA-Z0-9]/g, '');

                    $(this).val(sanitizedVal);

                    var errorElement = $(this).parent().find('.usernameError');

                    // Check if the input value matches the pattern
                    if (pattern.test(inputVal)) {
                        errorElement.text('');
                    } else {
                        errorElement.text(
                            'Only alphanumeric characters are allowed.'
                        );
                        isValid = false;
                    }


                });
            })
        })
    </script>
@endpush
