@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans('Edit Gateway', cons()::LANGUAGE_BACKEND) }}</h4>
            <a href="{{ route('panel.offline-gateways') }}" class="btn btn-sm btn-light"><i
                    class="ri-arrow-left-line"></i>{{ tt_trans('Back', cons()::LANGUAGE_BACKEND) }}</a>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('panel.offline-gateway-update', $gateway->id) }}"
                enctype="multipart/form-data">
                @csrf

                <div class="row g-3">
                    <div class="col-lg-12">
                        <label class="form-label mb-2">{{ tt_trans('Gateway image', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="image-upload">
                            <div class="image-preview">
                                <div style="background-image: url({{ getFile('gateways', $gateway->image) }});"
                                    class="bg-size-contain singleImage">
                                </div>
                            </div>
                            <div class="image-edit-btn">
                                <input type='file' name="image" id="image1" class="singleImageUpload"
                                    accept=".png, .jpg, .jpeg" />
                                <label for="image1" data-text="Upload"></label>
                            </div>
                        </div>
                    </div>


                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Currency Type', cons()::LANGUAGE_BACKEND) }}</label>
                        <select name="currency_type" class="form-select type">
                            <option value="{{ cons()::FIAT }}" @selected($gateway->currency_type == cons()::FIAT)>
                                {{ tt_trans('Fiat', cons()::LANGUAGE_BACKEND) }}</option>
                            <option value="{{ cons()::CRYPTO }}" @selected($gateway->currency_type == cons()::CRYPTO)>
                                {{ tt_trans('Crypto', cons()::LANGUAGE_BACKEND) }}
                            </option>
                        </select>
                    </div>

                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Gateway Name', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="name" class="form-control" placeholder="Enter gateway name"
                            value="{{ $gateway->name }}">
                    </div>

                    <div class="col-md-12" id="append">

                        @if ($gateway->currency_type == cons()::FIAT)
                            @if ($gateway->parameters->sending_options)
                                @foreach ($gateway->parameters->sending_options as $option)
                                    <div class="row align-items-end mb-3">
                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</label>
                                            <input type="text" required name="parameters[sending_options][{{$loop->index}}][title]"
                                                class="form-control" value="{{ $option->title }}">
                                        </div>

                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</label>
                                            <input type="text" required name="parameters[sending_options][{{$loop->index}}][value]"
                                                class="form-control" value="{{ $option->value }}">
                                        </div>

                                        @if($loop->first)

                                        <div class="col-auto">
                                            <button class="btn btn-sm btn-primary text-lg add"><i
                                                    class="fa fa-plus"></i></button>
                                        </div>
                                        @else
                                        <div class="col-auto">
                                            <button type="button" class="btn btn-sm btn-danger text-lg remove"><i class="fa fa-trash"></i></button>
                                        </div>

                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        @else
                            <div class="col-lg-12" id="crypto">
                                <label class="form-label">{{ tt_trans('Qr Code', cons()::LANGUAGE_BACKEND) }}</label>
                                <input type="file" name="parameters[sending_options][qr_code]" class="form-control">
                            </div>
                        @endif
                    </div>



                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Gateway currency', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" name="currency" class="form-control currency" placeholder="Enter Currency"
                            value="{{ $gateway->currency }}">
                    </div>
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Charge', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="input-group">
                            <input type="number" step="any" name="charge" class="form-control"
                                placeholder="Enter Method Charge" value="{{ $gateway->charge }}">
                            <select name="type" class="form-select">
                                <option value="{{ cons()::FIXED }}" {{ selectedOption($gateway->type == cons()::FIXED) }}>
                                    {{ tt_trans('Fixed', cons()::LANGUAGE_BACKEND) }}</option>
                                <option value="{{ cons()::PERCENTAGE }}"
                                    {{ selectedOption($gateway->type == cons()::PERCENTAGE) }}>
                                    {{ tt_trans('Percentage', cons()::LANGUAGE_BACKEND) }}
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <label class="form-label">{{ tt_trans('Conversion rate', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="input-group">
                            <span class="input-group-text text-sm">1 {{ tc()->get('currency') }} = </span>
                            <input type="text" name="rate" class="form-control" placeholder="Enter Method Charge"
                                value="{{ $gateway->rate }}">
                            <span class="input-group-text text-sm currencyAppear">{{ $gateway->currency }}</span>
                        </div>
                    </div>
                    <div class="col-lg-12 summer-note-form">
                        <label class="form-label">{{ tt_trans('Gateway Details', cons()::LANGUAGE_BACKEND) }}</label>
                        <textarea name="parameters[details]" class="summernote">
                            <?= $gateway->parameters?->details ?>
                        </textarea>
                    </div>

                    <div class="col-12">
                        <h4 class="card-title my-4">
                            {{ tt_trans('Payment verification requirements', cons()::LANGUAGE_BACKEND) }}</h4>

                        <div class="row gy-3" id="allRequirement">


                            @if ($gateway->parameters)
                                @foreach ($gateway->parameters->proof as $proof)
                                    <div class="col-12 single-requirement">
                                        <div class="row g-3 align-items-end">
                                            <div class="col-auto flex-grow-1">
                                                <label
                                                    class="form-label">{{ tt_trans('Label name', cons()::LANGUAGE_BACKEND) }}
                                                </label>
                                                <input type="text"
                                                    name="parameters[proof][{{ $loop->index }}][label_name]"
                                                    class="form-control" placeholder="Enter Label Name"
                                                    value="{{ $proof->label_name }}">
                                            </div>


                                            <div class="col-xxl-3 col-lg-6 col-12">
                                                <label
                                                    class="form-label">{{ tt_trans('Field name', cons()::LANGUAGE_BACKEND) }}

                                                    <span class="error usernameError"></span>
                                                </label>
                                                <input type="text"
                                                    name="parameters[proof][{{ $loop->index }}][field_name]"
                                                    class="form-control valid" placeholder="Enter Field Name"
                                                    value="{{ $proof->field_name }}">
                                            </div>
                                            <div class="col-auto flex-grow-1">
                                                <label
                                                    class="form-label">{{ tt_trans('Field type', cons()::LANGUAGE_BACKEND) }}
                                                </label>


                                                <select class="form-select"
                                                    name="parameters[proof][{{ $loop->index }}][field_type]">
                                                    @foreach (cons()->inputTypes as $key => $types)
                                                        <option value="{{ $key }}"
                                                            {{ selectedOption($proof->field_type == $key) }}>
                                                            {{ $types }}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                            <div class="col-auto flex-grow-1">
                                                <label
                                                    class="form-label">{{ tt_trans('Field validation', cons()::LANGUAGE_BACKEND) }}
                                                </label>
                                                <select class="form-select"
                                                    name="parameters[proof][{{ $loop->index }}][validation]">
                                                    @foreach (cons()->validations as $key => $validation)
                                                        <option value="{{ $key }}"
                                                            {{ selectedOption($proof->validation == $key) }}>
                                                            {{ $validation }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            @if ($loop->first)
                                                <div class="col-auto">
                                                    <button type="button" id="addRequirement"
                                                        class="btn btn-primary text-lg"><i
                                                            class="ri-add-line"></i></button>

                                                </div>
                                            @else
                                                <div class="col-auto">
                                                    <button type="button" class="btn btn-danger delete text-lg"><i
                                                            class="ri-close-line"></i></button>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            @endif


                        </div>
                    </div>

                    <div class="col-12">
                        <button type="submit"
                            class="btn btn-primary">{{ tt_trans('Update Changes', cons()::LANGUAGE_BACKEND) }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('#addRequirement').on('click', function(e) {
                e.preventDefault();


                const container = $('#allRequirement');
                const currentRows = container.find('.row');
                const newIndex = currentRows.length;

                $('#allRequirement').append(`
                <div class="col-12 single-requirement">
                    <div class="row g-3 align-items-end">
                       <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Label name', cons()::LANGUAGE_BACKEND) }}
                                            </label>
                                        <input type="text" name="parameters[proof][${newIndex}][label_name]" class="form-control"
                                            placeholder="Enter Label Name">
                                    </div>

                                    <div class="col-xxl-3 col-lg-6 col-12">
                                        <label class="form-label">{{ tt_trans('Field name', cons()::LANGUAGE_BACKEND) }}

                                            <span class="error usernameError"></span>
                                        </label>
                                        <input type="text" name="parameters[proof][${newIndex}][field_name]" class="form-control valid"
                                            placeholder="Enter Field Name">
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Field type', cons()::LANGUAGE_BACKEND) }}
                                            </label>
                                        <select class="form-select" name="parameters[proof][${newIndex}][field_type]">
                                            @foreach (cons()->inputTypes as $key => $types)
                                                <option value="{{ $key }}">{{ $types }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label
                                            class="form-label">{{ tt_trans('Field validation', cons()::LANGUAGE_BACKEND) }}
                                            </label>
                                        <select class="form-select" name="parameters[proof][${newIndex}][validation]">
                                            @foreach (cons()->validations as $key => $validation)
                                                <option value="{{ $key }}">{{ $validation }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                        <div class="col-auto">
                            <button type="button" class="btn btn-danger delete text-lg"><i class="ri-close-line"></i></button>
                        </div>
                    </div>
                </div>
            `);


            });

            $(document).on('click', '.delete', function() {
                $(this).closest('.single-requirement').remove();
            });


            $('.currency').on('keyup', function() {
                $('.currencyAppear').text($(this).val())
            })

            let crypto = `
               <div class="row align-items-end mb-3">
                    <div class="col-auto flex-grow-1">
                        <label class="form-label">{{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" required name="parameters[sending_options][0][title]" class="form-control"
                            value="">
                    </div>

                    <div class="col-auto flex-grow-1">
                        <label class="form-label">{{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="text" required name="parameters[sending_options][0][value]" class="form-control"
                            value="">
                    </div>

                    <div class="col-auto">
                        <button class="btn btn-sm btn-primary text-lg add"><i class="fa fa-plus"></i></button>
                    </div>
                </div>


            `;


            let qr = `

                <div class="col-lg-6" id="crypto">
                        <label class="form-label">{{ tt_trans('Qr Code', cons()::LANGUAGE_BACKEND) }}</label>
                        <input type="file" name="parameters[qr_code]" class="form-control">
                    </div>

            `;

            $(document).on('click', '.add', function(e) {
                e.preventDefault();

                const container = $('#append');
                const currentRows = container.find('.row');
                const newIndex = currentRows.length;
                const newRow = `
                        <div class="row align-items-end mb-3">
                            <div class="col-auto flex-grow-1">
                                <label class="form-label">{{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</label>
                                <input type="text" required name="parameters[sending_options][${newIndex}][title]" class="form-control" value="">
                            </div>
                            <div class="col-auto flex-grow-1">
                                <label class="form-label">{{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</label>
                                <input type="text" required name="parameters[sending_options][${newIndex}][value]" class="form-control" value="">
                            </div>
                            <div class="col-auto">
                                <button type="button" class="btn btn-sm btn-danger text-lg remove"><i class="fa fa-trash"></i></button>
                            </div>
                        </div>
                `;

                container.append(newRow);
            });

            $(document).on('click', '.remove', function(e) {
                e.preventDefault();
                $(this).closest('.row').remove();
            });

            function generateForm($value) {
                if ($value === 'fiat') {
                    $('#append').html(crypto);
                } else {
                    $('#append').html(qr);
                }
            }

            $('.type').on('change', function() {
                generateForm($(this).val())

            })



            $(document).on('keyup', '.valid', function(event) {
                var pattern = /^[a-zA-Z0-9]+$/;
                var isValid = true;
                $('.valid').each(function(index) {
                    var inputVal = $(this).val();

                    var sanitizedVal = inputVal.replace(/[^a-zA-Z0-9]/g, '');

                    $(this).val(sanitizedVal);

                    var errorElement = $(this).parent().find('.usernameError');

                    // Check if the input value matches the pattern
                    if (pattern.test(inputVal)) {
                        errorElement.text('');
                    } else {
                        errorElement.text(
                            'Only alphanumeric characters are allowed.'
                        );
                        isValid = false;
                    }


                });
            })
        })
    </script>
@endpush
