@extends('backend.layouts.master')
@section('panel')
    <form method="POST" action="" enctype="multipart/form-data">
        @csrf

        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card pb-4">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Ico Setting', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('Icon', cons()::LANGUAGE_BACKEND) }}
                                    </label>
                                    <div
                                        class="drop-zone drop-zone-sm border border-2 border-dashed border-light-primary rounded p-2 d-flex flex-column align-items-center justify-content-center bg-light-primary overflow-hidden text-center">
                                        <div
                                            class="prompt-text h-100 w-100 d-flex flex-column align-items-center justify-content-center">
                                            <span class="display-6 text-primary mb-3">
                                                <iconify-icon icon="solar:gallery-linear"></iconify-icon>
                                            </span>
                                            <h6 class="mb-1 text-sm"><span
                                                    class="font-semibold">{{ tt_trans('Click to upload', cons()::LANGUAGE_BACKEND) }}</span>
                                                {{ tt_trans('or drag and drop', cons()::LANGUAGE_BACKEND) }}</h6>
                                            <p class="text-xs mb-0 text-muted">
                                                {{ tt_trans('PNG, JPG or JPEG', cons()::LANGUAGE_BACKEND) }} </p>
                                        </div>
                                        <input type="file" name="icon"
                                            class="opacity-0 visually-hidden drop-zone-input" />
                                        <div class="drop-zone-thumb"
                                            style="background-image:url({{ getFile('ico_icon', $setting->icon ?? null) }})">
                                            <div class="overlay">
                                                <p class="thumbnail-file-name">{{ $setting->token_symbol ?? "" }}</p>
                                                <p class="overlay-prompt-text">
                                                    {{ tt_trans('Drag and drop or click to replace', cons()::LANGUAGE_BACKEND) }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="row gy-2">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Token Name', cons()::LANGUAGE_BACKEND) }}</label>
                                            <input type="text" name="token_name"
                                                value="{{ $setting->token_name ?? old('token_name') }}"
                                                class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Token Symbol', cons()::LANGUAGE_BACKEND) }}</label>
                                            <input type="text" name="token_symbol"
                                                value="{{ $setting->token_symbol ?? old('token_symbol') }}"
                                                class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Default Currency', cons()::LANGUAGE_BACKEND) }}</label>
                                            <select name="currency_id" id="" class="form-select-two">
                                                @foreach ($currencies as $currency)
                                                    <option value="{{ $currency->id }}" @selected($currency->id == ($setting->currency_id ?? old('currency_id')))>
                                                        {{ $currency->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Auction Buy Percentage', cons()::LANGUAGE_BACKEND) }}</label>
                                            <div class="input-group">
                                                <input type="number" step="any" name="auction_buy_percentage"
                                                    class="form-control"
                                                    value="{{ $setting->auction_buy_percentage ?? old('auction_buy_percentage') }}"
                                                    required>
                                                <span class="input-group-text">%</span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('Auction Refund Percentage', cons()::LANGUAGE_BACKEND) }}</label>
                                            <div class="input-group">
                                                <input type="number" step="any" name="auction_refund_percentage"
                                                    class="form-control"
                                                    value="{{ $setting->auction_refund_percentage ?? old('auction_refund_percentage') }}"
                                                    required>
                                                <span class="input-group-text">%</span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label
                                                class="form-label">{{ tt_trans('White Paper', cons()::LANGUAGE_BACKEND) }}</label>
                                            <input type="file" class="form-control" name="white_paper" accept=".pdf">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <button type="submit" class="btn btn-primary mt-4">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
        </div>
    </form>
@endsection

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
@endpush
