@extends('backend.layouts.master')
@section('panel')
    <div class="row justify-content-center">
        <div class="col-xl-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                        <h4 class="card-title mb-0">
                            {{ tt_trans('KYC Information', cons()::LANGUAGE_BACKEND) }}

                            @if ($kyc->status == cons()::PENDING)
                                <span class="badge badge-warning" data-bs-toggle="tooltip" data-bs-title="KYC verification">
                                    <i class="ri-loader-line"></i>
                                    {{ tt_trans('Pending', cons()::LANGUAGE_BACKEND) }}
                                </span>
                            @elseif($kyc->status == cons()::ACCEPTED)
                                <span class="badge badge-success" data-bs-toggle="tooltip" data-bs-title="KYC verification">
                                    <i class="ri-check-double-line"></i>
                                    {{ tt_trans('Accepted', cons()::LANGUAGE_BACKEND) }}
                                </span>
                            @else
                                <span class="badge badge-danger" data-bs-toggle="tooltip" data-bs-title="KYC verification">
                                    <i class="ri-close-line"></i>
                                    {{ tt_trans('Rejected', cons()::LANGUAGE_BACKEND) }}
                                </span>
                            @endif

                        </h4>
                        @if ($kyc->status == cons()::PENDING)
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal"
                                    data-bs-target="#accept"><i class="ri-check-line"></i>
                                    {{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                    data-bs-target="#reject"><i class="ri-close-line"></i>
                                    {{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="pt-3">
                        <div class="row gy-4 mb-5">
                            @foreach ($settings as $setting)
                                @if ($setting->field_type != 'file' && isset($kyc->kyc[$setting->field_name]))
                                    <div class="col-sm-6">
                                        <span class="text-sm text-muted">{{ $setting->label_name }}</span>
                                        <p class="mb-0 fw-semibold display-color">{{ $kyc->kyc[$setting->field_name] }}
                                        </p>
                                    </div>
                                @endif
                            @endforeach


                            @if ($kyc->status == cons()::REJECTED)
                                <div class="col-sm-12">
                                    <span class="text-sm text-muted">{{ tt_trans('Rejection Reason') }}</span>
                                    <p class="mb-0 fw-semibold display-color">{{ $kyc->reason }}
                                    </p>
                                </div>
                            @endif
                        </div>

                        <div class="row gy-4">
                            @foreach ($settings as $setting)
                                @if ($setting->field_type == 'file' && isset($kyc->kyc[$setting->field_name]))
                                    <div class="col-sm-4">
                                        <p class="mb-2">{{ $setting->label_name }}</p>
                                        <img src="{{ getFile('kyc', $kyc->kyc[$setting->field_name]) }}" alt="image"
                                            class="rounded-3">
                                        <a href="{{ getFile('kyc', $kyc->kyc[$setting->field_name]) }}"
                                            class="image-view btn btn-sm btn-primary w-100 text-center mt-3">
                                            {{ tt_trans('View Image', cons()::LANGUAGE_BACKEND) }}
                                        </a>
                                    </div>
                                @endif
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <x-modal id="accept" title="Accept Kyc Request" size="">
        <div class="d-flex flex-column justify-content-center align-items-center text-center">
            <div class="card-icon-lg bg-light-danger text-danger text-2xl item-center rounded-circle">
                <iconify-icon icon="ant-design:alert-outlined"></iconify-icon>
            </div>
            <h5 class="mt-4">{{ tt_trans('Are You Sure', cons()::LANGUAGE_BACKEND) }}?</h5>
            <p class="text-muted mb-0">{{ tt_trans('This will', cons()::LANGUAGE_BACKEND) }} <span
                    class="text-danger">{{ tt_trans('verify kyc request', cons()::LANGUAGE_BACKEND) }}</span>.
                {{ tt_trans("You can't undo this action.", cons()::LANGUAGE_BACKEND) }}.
            </p>

            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <form action="{{ route('panel.kyc-verification-accept', $kyc->id) }}" method="post">
                    @csrf
                    <button type="submit"
                        class="btn btn-success">{{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                </form>
            </div>


        </div>



    </x-modal>



    <x-modal id="reject" title="Reject Kyc Request" size="">

        <form action="{{ route('panel.kyc-verification-reject', $kyc->id) }}" method="post">
            @csrf
            <div class="row mb-3">
                <div class="col-md-12">
                    <label for="form-label">{{ tt_trans('Reason For Rejection', cons()::LANGUAGE_BACKEND) }}</label>
                    <textarea name="reason" class="form-control" cols="30" rows="10"></textarea>
                </div>
            </div>


            <button type="button" class="btn btn-light"
                data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
            <button type="submit" class="btn btn-danger">{{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
        </form>

    </x-modal>
@endsection

@push('script')
    <link rel="stylesheet" href="{{ css('magnific-popup.css') }}">
@endpush

@push('script')
    <script src="{{ js('magnifc-popup.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            'use strict'
            $('.image-view').magnificPopup({
                type: 'image'
            });
        });
    </script>
@endpush
