@extends('backend.layouts.master')

@section('panel')

<div class="card">
    <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
        <h4 class="card-title mb-0">{{tt_trans(str_replace('_',' ', request()->has('sort') ? ucwords(request()->sort) : 'All kyc' ), cons()::LANGUAGE_BACKEND)  }} {{ tt_trans("request",cons()::LANGUAGE_BACKEND) }}</h4>
        <div class="d-flex flex-wrap align-items-center gap-2">
            <form class="d-flex align-items-center gap-2" method="GET">


                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div class="position-relative">
                        <input type="text" name="from" class="form-control form-control-sm datepickerWithIcon"
                            autocomplete="off" placeholder="{{tt_trans('MM/DD/YYYY',cons()::LANGUAGE_BACKEND)}}" value="{{request()->from}}">
                    </div>
                    <span>{{ tt_trans('to', cons()::LANGUAGE_BACKEND) }} </span>
                    <div class="position-relative">
                        <input type="text" name="to" class="form-control form-control-sm datepickerWithIcon"
                            autocomplete="off" placeholder="{{tt_trans('MM/DD/YYYY',cons()::LANGUAGE_BACKEND)}}" value="{{request()->to}}">
                    </div>
                </div>



                @if (request()->has('from') || request()->has('to'))
                    <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                            class="ri-close-large-line"></i>
                        {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                @endif


                <button type="submit" class="btn btn-sm btn-primary">
                    <i class="ri-filter-3-line"></i>
                    <span>{{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </form>
            <div class="dropdown dropdown-menu-end">
                <button type="button" class="btn btn-sm btn-light" data-bs-toggle="dropdown">
                    <i class="ri-arrow-up-down-line"></i>
                    <span>{{ tt_trans('Sort', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a class="dropdown-item d-flex align-items-center gap-3" href="{{ route('panel.kyc-verification-request') }}">
                            <span class="text-lg"><iconify-icon icon="octicon:unverified-24"></iconify-icon></span>
                            <span>{{ tt_trans('All Kyc', cons()::LANGUAGE_BACKEND) }}</span>
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center gap-3"
                            href="{{ route('panel.kyc-verification-request',['sort'=>'pending_kyc']) }}">
                            <span class="text-lg"><iconify-icon icon="octicon:unverified-24"></iconify-icon></span>
                            <span>{{ tt_trans('Kyc Pending', cons()::LANGUAGE_BACKEND) }}</span>
                            <span class="badge badge-danger rounded-pill ms-auto">{{ $pending_kyc_request }}</span>
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center gap-3"
                            href="{{ route('panel.kyc-verification-request',['sort'=>'accept_kyc']) }}">
                            <span class="text-lg"><iconify-icon icon="octicon:unverified-24"></iconify-icon></span>
                            <span>{{ tt_trans('Kyc Accept', cons()::LANGUAGE_BACKEND) }}</span>
                            <span class="badge badge-success rounded-pill ms-auto">{{ $accept_kyc_request }}</span>
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center gap-3"
                            href="{{ route('panel.kyc-verification-request',['sort'=>'reject_kyc']) }}">
                            <span class="text-lg"><iconify-icon icon="octicon:unverified-24"></iconify-icon></span>
                            <span>{{ tt_trans('Kyc Reject', cons()::LANGUAGE_BACKEND) }}</span>
                            <span class="badge badge-secondary rounded-pill ms-auto">{{ $reject_kyc_request }}</span>
                        </a>
                    </li>

                </ul>
            </div>
        </div>
    </div>
    <div class="card-body">
        <x-table>
            <tr>
                <th scope="col"><i class="ri-profile-line"></i>{{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}
                </th>

                <th scope="col"><i class="ri-calendar-2-line"></i>{{ tt_trans('Request Time', cons()::LANGUAGE_BACKEND) }}
                </th>
                <th scope="col"><i class="ri-checkbox-circle-line"></i>
                    {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                <th scope="col"><i class="ri-arrow-right-up-line"></i>
                    {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
            </tr>

            <x-slot name="tablebody">
                @forelse ($kycrequests as $kyc)
                    <tr>
                        <td>
                            <div class="d-flex align-items-center gap-2">
                                <img src="{{ getFile('user', $kyc->user?->image) }}" alt="image" class="avatar-lg rounded-2">
                                <div>
                                    <h6 class="text-sm mb-0"><a href="{{route('panel.user.details', $kyc->user?->id)}}"
                                            class="text-primary text-line-1 w-150px">{{ $kyc->user?->full_name }}</a></h6>
                                    <p class="text-xs mt-1 mb-0 line-height-1 text-muted text-line-1 w-150px">{{ $kyc->user?->email }}</p>
                                </div>
                            </div>
                        </td>

                        <td>{{ dateFormatter($kyc->created_at) }}</td>

                        <td>
                            <?=status($kyc)?>
                        </td>

                        <td>
                            <div class="d-flex flex-wrap align-items-center gap-2">
                                <a href="{{ route('panel.kyc-verification-details', $kyc->id) }}"
                                    class="btn btn-icon btn-primary rounded-circle">
                                    <i class="ri-eye-line"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                @empty
                    <x-no-data></x-no-data>
                @endforelse

            </x-slot>
        </x-table>
    </div>
</div>


@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $(".datepickerWithIcon").datepicker({
                showOn: "button",
                buttonImageOnly: false,
            });
        })
    </script>
@endpush

