@extends('backend.layouts.master')

@section('panel')
    <div class="row gy-4">

        @foreach ($languages as $lang)    
        <div class="col-xxl-3 col-xl-4 col-sm-6">
            <div class="card">
                <div class="p-3">
                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <img src="{{getFile('language', $lang->image)}}" alt="image" class="avatar-md rounded-circle">
                        <div>
                            <h5 class="mb-0 text-md">{{$lang->name}}</h5>
                            <p class="mb-0 text-xs">{{tt_trans('created at')}} {{dateFormatter($lang->created_at)}}</p>
                        </div>
                        <button type="button" class="text-primary text-lg ms-auto edit" data-lang="{{$lang}}" data-bs-toggle="modal"
                            data-bs-target="#edit" data-action="{{route('panel.language.update', $lang->id)}}">
                            <span data-bs-toggle="tooltip" data-bs-title="Language edit"><i class="ri-edit-line"></i></span>
                        </button>
                        <button type="button" class="text-danger text-lg delete" data-bs-toggle="modal"
                            data-bs-target="#delete" data-action="{{route('panel.language.destroy', $lang->id)}}">
                            <span data-bs-toggle="tooltip" data-bs-title="Delete the language"><i
                                    class="ri-delete-bin-5-line"></i></span>
                        </button>
                    </div>
                    <a href="{{route('panel.translate', $lang->code)}}" class="btn btn-primary w-100 mt-4">{{tt_trans('Translate Now',cons()::LANGUAGE_BACKEND)}} <i
                            class="ri-arrow-right-line"></i></a>
                </div>
            </div>
        </div>
        @endforeach

        <div class="col-xxl-3 col-xl-4 col-sm-6">
            <div
                class="card h-100 p-3 py-4 border border-2 border-dashed border-light-primary position-relative d-flex justify-content-center align-items-center">
                <button type="button" class="position-absolute z-1 top-0 start-0 w-100 h-100" data-bs-toggle="modal"
                    data-bs-target="#add"></button>
                <div class=" d-flex flex-wrap align-items-center justify-content-center gap-3">
                    <span class="text-primary text-2xxl">
                        <iconify-icon icon="ic:outline-language"></iconify-icon>
                    </span>
                    <h6 class="mb-0 text-md text-primary">{{ tt_trans('Add Language', cons()::LANGUAGE_BACKEND) }}</h6>
                </div>
            </div>
        </div>
    </div>

    <x-modal id="add" title="Add New Language" size="">
        <form method="POST" action="{{route('panel.language.store')}}" enctype="multipart/form-data">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Language image',cons()::LANGUAGE_BACKEND)}}</label>
                <input class="form-control" name="image" type="file" id="formFile">

            </div>
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Language name',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="text" name="name" class="form-control" placeholder="Enter Language Name">
            </div>
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Language short name',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="text" name="code" class="form-control" placeholder="Enter Language Short Name">
            </div>
            <button type="submit" class="btn btn-primary">{{tt_trans('Save Now',cons()::LANGUAGE_BACKEND)}}</button>
        </form>
    </x-modal>


    <x-modal id="edit" title="Update Language" size="">
        <form method="POST" action="{{route('panel.language.store')}}" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Language image',cons()::LANGUAGE_BACKEND)}}</label>
                <input class="form-control" name="image" type="file" id="formFile">

            </div>
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Language name',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="text" name="name" class="form-control" placeholder="Enter Language Name">
            </div>
           
            <button type="submit" class="btn btn-primary">{{tt_trans('Save Now',cons()::LANGUAGE_BACKEND)}}</button>
        </form>
    </x-modal>
@endsection

@push('script')

<script>
    $(function(){
        'use strict'

        $('.edit').on('click', function(){
            $('#edit').find('form').attr('action', $(this).data('action'));
            $('#edit').find('input[name=name]').val($(this).data('lang').name);
            $('#edit').find('input[name=code]').val($(this).data('lang').code);
        })
    })
</script>
    
@endpush
