@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{ tt_trans('Language Table', cons()::LANGUAGE_BACKEND) }}</h4>
                <div class="d-flex flex-wrap align-items-center gap-3">
                    <button class="btn btn-light sync " data-lang="{{ $lang->code }}">
                        <span class="sync-icon"><i class="ri-loop-left-line"></i></span>
                        {{ tt_trans('Sync From Default', cons()::LANGUAGE_BACKEND) }}
                    </button>
                    <ul class="nav nav-tabs nav-tabs-sm light-bg-tab border-0" id="myTab" role="tablist">
                        @php
                            $isActive = (request()->frontend == '') && (request()->backend == '') && (request()->notification == '') ? true : false
                        @endphp
                        <li class="nav-item" role="presentation">
                            <button class="nav-link {{$isActive ? 'active' : ''}} {{ request()->frontend ? 'active' : '' }}" id="frontend-tab"
                                data-bs-toggle="tab" data-bs-target="#frontend" type="button" role="tab"
                                aria-controls="frontend"
                                aria-selected="false">{{ tt_trans('Frontend Content', cons()::LANGUAGE_BACKEND) }}</button>
                        </li>


                        <li class="nav-item" role="presentation">
                            <button class="nav-link {{ request()->notification ? 'active' : '' }}" id="notification-tab"
                                data-bs-toggle="tab" data-bs-target="#notification" type="button" role="tab"
                                aria-controls="notification"
                                aria-selected="false">{{ tt_trans('Notification Content', cons()::LANGUAGE_BACKEND) }}</button>
                        </li>


                        <li class="nav-item" role="presentation">
                            <button class="nav-link {{ request()->backend ? 'active' : '' }}" id="backend-tab"
                                data-bs-toggle="tab" data-bs-target="#backend" type="button" role="tab"
                                aria-controls="backend"
                                aria-selected="true">{{ tt_trans('Admin Content', cons()::LANGUAGE_BACKEND) }}</button>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade  {{ request()->backend ? 'show active' : '' }}" id="backend" role="tabpanel"
                    aria-labelledby="tab1a-tab" tabindex="0">
                    <div class="position-relative mb-3">
                        <input type="text" name="search" class="form-control bg-light-light ps-35 search-backend"
                            placeholder="Search language key...">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <form  method="post" class="lang-form-area">
                        @csrf
                        <input type="hidden" name="name" value="backend">
                        <x-table :paginations="$backend" id="search-backend">
                            <tr>
                                <th scope="col"><i class="ri-account-circle-line"></i>
                                    {{ tt_trans('Key', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-mail-line"></i>
                                    {{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</th>

                            </tr>

                            <x-slot name="tablebody">
                                @forelse ($backend as $key => $trans)
                                    <tr>
                                        <td class="w-50">
                                            {{ $key }}
                                        </td>
                                        <td class="w-50">
                                            <input type="text" name="translations[{{ $key }}]"
                                                class="form-control" placeholder="Enter Value" value="{{ $trans }}">
                                        </td>

                                    </tr>
                                @empty
                                    <x-no-data></x-no-data>
                                @endforelse

                            </x-slot>

                        </x-table>
                        <div class="text-end submit-button">
                            <button
                                class="btn btn-primary">{{ tt_trans('Update Translation', cons()::LANGUAGE_BACKEND) }}</button>
                        </div>
                    </form>
                </div>
                <div class="tab-pane fade {{$isActive ? 'show active' : ''}} {{ request()->frontend? 'show active' : '' }}" id="frontend" role="tabpanel"
                    aria-labelledby="tab2a-tab" tabindex="0">
                    <div class="position-relative mb-3">
                        <input type="text" name="search" class="form-control bg-light-light ps-35 search-frontend"
                            placeholder="Search language key...">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <form  method="post" class="lang-form-area">
                        @csrf
                        <input type="hidden" name="name" value="frontend">
                        <x-table :paginations="$frontend" id="search-frontend">
                            <tr>
                                <th scope="col"><i class="ri-account-circle-line"></i>
                                    {{ tt_trans('Key', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-mail-line"></i>
                                    {{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</th>

                            </tr>

                            <x-slot name="tablebody">

                                @forelse ($frontend as $key => $trans)
                                    <tr>
                                        <td class="w-50">
                                            {{ $key }}
                                        </td>
                                        <td class="w-50">
                                            <input type="text" name="translations[{{ $key }}]"
                                                class="form-control" placeholder="Enter Value"
                                                value="{{ $trans }}">
                                        </td>

                                    </tr>
                                @empty
                                    <x-no-data></x-no-data>
                                @endforelse

                            </x-slot>

                        </x-table>

                        <div class="text-end submit-button">
                            <button
                                class="btn btn-primary">{{ tt_trans('Update Translation', cons()::LANGUAGE_BACKEND) }}</button>
                        </div>

                    </form>
                </div>
                <div class="tab-pane fade {{ request()->notification ? 'show active' : '' }}" id="notification"
                    role="tabpanel" aria-labelledby="tab3a-tab" tabindex="0">
                    <div class="position-relative mb-3">
                        <input type="text" name="search" class="form-control bg-light-light ps-35 search-notification"
                            placeholder="Search language key...">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <form  method="post" class="lang-form-area">
                        @csrf
                        <input type="hidden" name="name" value="notification">
                        <x-table :paginations="$notification" id="search-notification">
                            <tr>
                                <th scope="col"><i class="ri-account-circle-line"></i>
                                    {{ tt_trans('Key', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-mail-line"></i>
                                    {{ tt_trans('Value', cons()::LANGUAGE_BACKEND) }}</th>

                            </tr>

                            <x-slot name="tablebody">

                                @forelse ($notification as $key => $trans)
                                    <tr>
                                        <td class="w-50">
                                            {{ $key }}
                                        </td>
                                        <td class="w-50">
                                            <input type="text" name="translations[{{ $key }}]"
                                                class="form-control" placeholder="Enter Value"
                                                value="{{ $trans }}">
                                        </td>

                                    </tr>
                                @empty
                                    <x-no-data></x-no-data>
                                @endforelse


                            </x-slot>

                        </x-table>
                        <div class="text-end submit-button">
                            <button class="btn btn-primary">{{ tt_trans('Update Translation', cons()::LANGUAGE_BACKEND) }}</button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('.sync').on('click', function() {
                $(this).addClass("sync-animation")
                sendHttpRequest("GET", "{{ route('panel.sync-translation') }}", {
                    code: "{{ $lang->code }}"
                }, "{{ url()->current() }}", true)

                $(document).ajaxStop(function() {
                    $(this).removeClass("sync-animation")
                });
            })

            $(document).on("keyup",".search-backend", function() {

                var value = $(this).val().toLowerCase();

                sendHttpRequest('GET', "{{ route('panel.translation-search') }}", {
                    search: value,
                    code: "{{ $lang->code }}",
                    'type': 'backend'
                }, '#search-backend')
            });


            $(document).on("keyup",".search-frontend", function() {

                var value = $(this).val().toLowerCase();

                sendHttpRequest('GET', "{{ route('panel.translation-search') }}", {
                    search: value,
                    code: "{{ $lang->code }}",
                    'type': 'frontend'
                }, '#search-frontend')
            });


            $(document).on("keyup",".search-notification", function() {

                var value = $(this).val().toLowerCase();

                sendHttpRequest('GET', "{{ route('panel.translation-search') }}", {
                    search: value,
                    code: "{{ $lang->code }}",
                    'type': 'notification'
                }, '#search-notification')
            });
        })
    </script>
@endpush

@push('style')
    <style>
        .lang-form-area {
            display: flex;
            flex-wrap: wrap;
        }

        .lang-form-area .table-responsive {
            order: 1;
            width: 100%;
        }

        .lang-form-area .submit-button {
            order: 3;
            width: 165px;
            text-align: end;
        }

        .lang-form-area .pagination-style-two {
            order: 2;
            width: calc(100% - 165px);
            justify-content: flex-start !important;
        }

        .sync-animation .sync-icon {
            display: inline-block;
            animation: spin 2s infinite linear;
        }

        @keyframes spin {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        .form-control {
            border-color: #c9c9c9;
        }
    </style>
@endpush
