<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ tc()->get('sitename') }}</title>

    <link rel="icon" type="image/png" href="{{ getFile('icon', $themeSettings->icon) }}" sizes="16x16">

    <link rel="stylesheet" href="{{ css('remixicon.css') }}">

    <link rel="stylesheet" href="{{ css('all.min.css') }}">

    <link rel="stylesheet" href="{{ css('bootstrap-icons.min.css') }}">

    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ css('jquery.toast.min.css') }}">

    <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_BACKEND) }}">
</head>

<body>

    <main class="admin-auth-main"
        style="background-image: url({{ getFile('background', tc()->get('background'), '1920x1000') }});">
        <div class="admin-auth-body border border-2 border-light-primary">
            <div class="text-center mb-4">
                <h3>{{ tt_trans('Welcome', cons()::LANGUAGE_BACKEND) }} {{ tc()->get('sitename') }}</h3>
                <p class="mb-0">{{ tt_trans('Admin Login to', cons()::LANGUAGE_BACKEND) }}
                    {{ tc()->get('sitename') }} {{ tt_trans('Dashboard', cons()::LANGUAGE_BACKEND) }}</p>
            </div>
            @yield('panel')

        </div>
    </main>

    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>
    <script src="{{ js('jquery-ui.min.js') }}"></script>
    <script src="{{ js('jquery.toast.min.js') }}"></script>
    <script src="{{ js('bootstrap.bundle.min.js') }}"></script>

    @include('alert')
</body>

</html>
