<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ tc()->get('sitename') }}</title>
    <link rel="icon" type="image/png" href="{{ getFile('icon', $themeSettings->icon) }}" sizes="16x16">

    <link rel="stylesheet" href="{{ css('remixicon.css') }}">

    <link rel="stylesheet" href="{{ css('all.min.css') }}">

    <link rel="stylesheet" href="{{ css('bootstrap-icons.min.css') }}">

    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ css('jquery-ui.min.css') }}">

    <link rel="stylesheet" href="{{ css('jquery.toast.min.css') }}">

    <link rel="stylesheet" href="{{ css('bootstrap-toggle.min.css') }}">

    <link rel="stylesheet" href="{{ css('select2.min.css') }}">
    <!-- main css -->
    <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_BACKEND) }}">

    @stack('style')
</head>

<body>
    @include('backend.panel_layouts.sidebar')
    <main class="dashboard-main">
        @include('backend.panel_layouts.topbar')

        <div class="dashboard-main-body">
            <div id="liveAlertPlaceholder">

            </div>
            @yield('panel')
        </div>

        @include('backend.panel_layouts.footer')

        <x-modal id="aimodal" size="modal-lg" :isHeader=false>
            <form id="promptForm">
                @csrf
                <div class="col-md-12 mb-3">
                    <label
                        class="form-label">{{ tt_trans('Write a promt what you want to generate :', cons()::LANGUAGE_BACKEND) }}</label>
                    <textarea id="prompt" class="form-control" name="prompt" cols="6" rows="8" required
                        placeholder="Write a promt"></textarea>
                </div>

                <input type="hidden" name="target">

                <button type="submit"
                    class="btn btn-secondary">{{ tt_trans('Generate Text', cons()::LANGUAGE_BACKEND) }}</button>
            </form>
        </x-modal>


        <x-modal id="delete" size="" :isHeader="false">
            <div class="d-flex flex-column justify-content-center align-items-center text-center">
                <div class="card-icon-lg bg-light-danger text-danger text-2xl item-center rounded-circle">
                    <iconify-icon icon="ant-design:alert-outlined"></iconify-icon>
                </div>
                <h5 class="mt-4">{{ tt_trans('Are You Sure', cons()::LANGUAGE_BACKEND) }}?</h5>
                <p class="text-muted mb-0">{{ tt_trans('This will', cons()::LANGUAGE_BACKEND) }} <span
                        class="text-danger">{{ tt_trans('delete this record permanently', cons()::LANGUAGE_BACKEND) }}</span>.
                    {{ tt_trans(
                        "You can't undo this action. All values associated with this field will be lost",
                        cons()::LANGUAGE_BACKEND,
                    ) }}.
                </p>
                <div class="d-flex align-items-center gap-2 mt-4">
                    <button type="button" class="btn btn-light"
                        data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                    <form method="post">
                        @csrf
                        @method('DELETE')
                        <button type="submit"
                            class="btn btn-danger">{{ tt_trans('Delete', cons()::LANGUAGE_BACKEND) }}</button>
                    </form>
                </div>
            </div>
        </x-modal>
    </main>

    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>
    <script src="{{ js('jquery-ui.min.js') }}"></script>
    <script src="{{ js('jquery.toast.min.js') }}"></script>
    <script src="{{ js('bootstrap.bundle.min.js') }}"></script>
    <script src="{{ js('iconify-icon.min.js') }}"></script>
    <script src="{{ js('bootstrap-toggle.min.js') }}"></script>
    <script src="{{ js('select2.min.js') }}"></script>
    <script src="{{ js('jquery.basictable.min.js') }}"></script>
    <script src="{{ js('jquery-ui-touch-punch.min.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('app.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script src="{{ js('nicEdit.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script src="{{ js('ai.js') }}"></script>



    <script>
        'use strict';


        $('#addForm').on('submit', function(e) {

            e.preventDefault();

            sendHttpRequest("POST", $(this).attr('action'), $(this).serialize(), "{{ url()->current() }}", true);

        })

        $('#editForm').on('submit', function(e) {

            e.preventDefault();

            sendHttpRequest("PUT", $(this).attr('action'), $(this).serialize(), "{{ url()->current() }}", true);
        })




        $(document).on('click', '.aigenerator', function() {
            $('#promptForm').find('input[name=target]').val($(this).data('output'))
        })

        $('#promptForm').on('submit', function(e) {
            e.preventDefault();
            const prompt = $('#prompt').val();
            const target = $('input[name=target]').val();
            if ($('#' + target).hasClass('summernote')) {
                const nicEditorInstance = nicEditors.findEditor(target);
                const currentContent = nicEditorInstance.getContent();
                nicEditorInstance.setContent('');
            } else {
                $('#' + target).val("")
            }
            $('#aimodal').modal('hide')
            fetchOpenAIResponse("{{ tc()->get('ai_key') }}", prompt, target);
        })
    </script>


    @if (tc()->get('pusher_status'))
        <script src="{{ js('pusher.min.js') }}"></script>


        <script>
            'use strict';

            var pusher = new Pusher("{{ tc()->get('pusher_app_key') }}", {
                cluster: "{{ tc()->get('pusher_app_cluster') }}"
            });


            $(document).on('click', '.single-push-close', function() {
                $(this).closest('.single-push-notification').remove()
            })


            var channel = pusher.subscribe('notifications');
            channel.bind('admin-notification', function(data) {

                const alertPlaceholder = $('#liveAlertPlaceholder');
                const notificationHtml = `
                        <div class="single-push-notification">
                            <span class="single-push-icon">
                                <iconify-icon icon="ph:seal-check-fill"></iconify-icon>
                            </span>
                            <p class="single-push-details mb-0">${data.message}</p>
                            <button type="button" class="single-push-close" aria-label="Close"><i class="ri-close-line"></i></button>
                        </div>
                    `;

                // Append notification
                const $toast = $(notificationHtml).appendTo(alertPlaceholder);

                // Automatically add hide class after 4 seconds, then remove it from DOM
                setTimeout(function() {
                    $toast.fadeOut(1000, function() {
                        $(this).remove();
                    });
                }, 4000);


            });
        </script>
    @endif
    <script>
        'use strict';
        bkLib.onDomLoaded(function() {
            document.querySelectorAll('.summernote').forEach(function(textarea) {
                // Check if nicEditor is already initialized to avoid duplicates
                if (!textarea.nicEditorInstance) {
                    const editor = new nicEditor({
                        fullPanel: true
                    }).panelInstance(textarea, {
                        hasPanel: true
                    });
                    textarea.nicEditorInstance = editor; // Store editor instance

                    // Set the editor width to 100%
                    const nicEditMain = textarea.closest('.nicEdit-main');
                    if (nicEditMain) {
                        nicEditMain.style.width = '100%';
                    }
                }
            });
        });

        $('#myModal').on('shown.bs.modal', function() {
            new nicEditor({
                buttonList: ['bold', 'italic', 'underline', 'forecolor'] // Enable color picker
            }).panelInstance('myTextArea');
        });


        $('.form-select-two').select2({
            placeholder: 'Select an option'
        });


        $(".form-select-two-tokenizer").select2({
            tags: true,
            tokenSeparators: [',', ' ']
        })


        $('[data-toggle="dropdown"]').each(function() {
            $(this).attr('data-bs-toggle', 'dropdown');
            $(this).removeAttr('data-toggle');
        });


        $('.delete').on('click', function() {
            $('#delete').find('form').attr('action', $(this).data('action'));
        })


        function readURL(input, imageElement) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    imageElement.css('background-image', 'url(' + e.target.result + ')');
                    imageElement.hide();
                    imageElement.fadeIn(650);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        $(document).on('change', '.singleImageUpload', function() {
            var imageElement = $(this).closest('.image-upload').find('.singleImage');
            readURL(this, imageElement);
        });

        function changeStatus(model, column, id) {
            $.ajax({
                url: "{{ route('panel.changeStatus') }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    model: model,
                    column: column,
                    id: id
                },
                success: function(response) {

                    if (response.status) {
                        $.toast({
                            text: response.message,
                            showHideTransition: 'slide',
                            bgColor: 'var(--success)',
                            textColor: '#fff',
                            allowToastClose: true,
                            hideAfter: 5000,
                            stack: 5,
                            textAlign: 'left',
                            position: 'top-right'
                        })

                    } else {
                        $.toast({
                            text: response.message,
                            showHideTransition: 'slide',
                            bgColor: 'var(--danger)',
                            textColor: '#fff',
                            allowToastClose: true,
                            hideAfter: 5000,
                            stack: 5,
                            textAlign: 'left',
                            position: 'top-right'
                        })
                    }

                }

            })
        }

        $(document).on('click', '.edit', function() {

            $('#edit').modal('show');
            $('#edit form').find('.invalid-feedback').remove();

            $('#edit form').find('.is-invalid').removeClass('is-invalid');
            var collections = $(this).data('collections');

            $.each(collections, function(key, value) {
                if ($('#edit').find('[name="' + key + '"]').length) {
                    $('#edit').find('[name="' + key + '"]').val(value);
                }
            });

            $('#edit form').attr('action', $(this).data('action'));
        });

        function sendHttpRequest(method, url, data, locationIdOrHref, isRedirect = false) {
            $.ajax({
                method: method,
                url: url,
                data: data,
                success: function(response) {
                    if (isRedirect) {

                        $.toast({
                        text: response.message,
                        showHideTransition: 'slide',
                        bgColor: 'var(--success)',
                        textColor: '#fff',
                        allowToastClose: true,
                        hideAfter: 5000,
                        stack: 5,
                        textAlign: 'left',
                        position: 'top-right'
                    })


                    
                        window.location.href = locationIdOrHref
                    } else {
                        $(locationIdOrHref).html(response)
                    }

                    setTimeout(function() {
                        document.querySelectorAll('.summernote').forEach(function(textarea) {
                            if (!textarea.nicEditorInstance) {
                                const editor = new nicEditor({
                                    fullPanel: true
                                }).panelInstance(textarea, {
                                    hasPanel: true
                                });
                                textarea.nicEditorInstance = editor;
                                const nicEditMain = textarea.closest('.nicEdit-main');
                                if (nicEditMain) {
                                    nicEditMain.style.width = '100%';
                                }
                            }
                        });
                    }, 100);
                },
                error: function(response) {
                    if (response.status === 422) {
                        let errors = response.responseJSON.errors;

                        $.each(errors, function(key, value) {
                            let inputField = $('form').not('[method="GET"]').find('[name="' + key +
                                '"]').not('[type=hidden]');

                            if (inputField.next('.invalid-feedback').length === 0) {
                                inputField.addClass('is-invalid');
                                inputField.after(
                                    `<div class="invalid-feedback">${value}</div>`
                                );
                            }
                        });
                    }

                }
            })
        }
    </script>
    @include('alert')

    @stack('script')

</body>

</html>
