@extends('backend.layouts.master')

@section('panel')
    <form action="" method="post">
        @csrf
        <div class="row">
            <div class="col-xxl-6">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Header Menu', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <select class="form-select bg-light-light mb-4" id="sectionSelect">
                            <option selected>{{ tt_trans('Select Section', cons()::LANGUAGE_BACKEND) }}</option>
                            @foreach ($pages as $page)
                                <option value="{{ $page->id }}">{{ $page->name }}</option>
                            @endforeach

                        </select>

                        <ul id="sortable"
                            class="sections-list p-3 bg-light-primary border border-2 border-dashed border-light-primary rounded">
                            @foreach ($headerMenus as $menu)
                                <li
                                    class="single-item py-2 px-3 bg-white rounded shadow-xs d-flex align-items-center gap-2">
                                    <span class="text-lg text-primary">
                                        <iconify-icon icon="oui:sortable"></iconify-icon>
                                    </span>
                                    <input type="hidden" name="header[]" value="{{ $menu->page_id }}">
                                    <span>{{ $menu->name }}</span>
                                    <button type="button" class="p-1 py-0 text-xl text-danger ms-auto item-remove-btn">
                                        <i class="ri-close-line"></i>
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-xxl-6">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Auth Menu', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <select class="form-select bg-light-light mb-4" id="sectionSelect-foot">
                            <option selected>{{ tt_trans('Select Section', cons()::LANGUAGE_BACKEND) }}</option>
                            @foreach ($pages as $page)
                                <option value="{{ $page->id }}">{{ $page->name }}</option>
                            @endforeach

                        </select>

                        <ul id="sortable-foot"
                            class="sections-list p-3 bg-light-primary border border-2 border-dashed border-light-primary rounded">
                            @foreach ($footerMenus as $menu)
                                <li
                                    class="single-item py-2 px-3 bg-white rounded shadow-xs d-flex align-items-center gap-2">
                                    <span class="text-lg text-primary">
                                        <iconify-icon icon="oui:sortable"></iconify-icon>
                                    </span>
                                    <input type="hidden" name="footer[]" value="{{ $menu->page_id }}">
                                    <span>{{ $menu->name }}</span>
                                    <button type="button" class="p-1 py-0 text-xl text-danger ms-auto item-remove-btn">
                                        <i class="ri-close-line"></i>
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-end mt-4">
            <button class="btn btn-primary">{{ tt_trans('Update Menu', cons()::LANGUAGE_BACKEND) }}</button>
        </div>
    </form>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $("#sortable").sortable();
            $("#sortable").disableSelection();
            // Append selected option to sortable list
            $('#sectionSelect').change(function() {
                var selectedOption = $(this).val();
                var text = $('#sectionSelect option:selected').text()
                if (selectedOption) {
                    $('#sortable').append(`
                    <li class="single-item py-2 px-3 bg-white rounded shadow-xs d-flex align-items-center gap-2">
                        <span class="text-lg text-primary">
                            <iconify-icon icon="oui:sortable"></iconify-icon>
                        </span>
                        <input name="header[]" type="hidden" value="${selectedOption}">
                        <span>${text}</span>
                        <button type="button" class="p-1 py-0 text-xl text-danger ms-auto item-remove-btn">
                            <i class="ri-close-line"></i>
                        </button>
                    </li>
                `);
                    $(this).prop('selectedIndex', 0); // Reset select to default
                }
            });



            $("#sortable-foot").sortable();
            $("#sortable-foot").disableSelection();
            // Append selected option to sortable list
            $('#sectionSelect-foot').change(function() {
                var selectedOption = $(this).val();
                var text = $('#sectionSelect-foot option:selected').text()
                if (selectedOption) {
                    $('#sortable-foot').append(`
                    <li class="single-item py-2 px-3 bg-white rounded shadow-xs d-flex align-items-center gap-2">
                        <span class="text-lg text-primary">
                            <iconify-icon icon="oui:sortable"></iconify-icon>
                        </span>
                        <input name="footer[]" type="hidden" value="${selectedOption}">
                        <span>${text}</span>
                        <button type="button" class="p-1 py-0 text-xl text-danger ms-auto item-remove-btn">
                            <i class="ri-close-line"></i>
                        </button>
                    </li>
                `);
                    $(this).prop('selectedIndex', 0); // Reset select to default
                }
            });
            // Remove the single-item when the remove button is clicked
            $(document).on('click', '.item-remove-btn', function() {
                $(this).closest('.single-item').remove();
            });





        })
    </script>
@endpush
