@extends('backend.layouts.master')

@section('panel')
    <div class="row gy-4 justify-content-center">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <x-table>
                        <tr>
                            <th scope="col"><i class="ri-mail-line"></i>
                                {{ tt_trans('Notification', cons()::LANGUAGE_BACKEND) }}</th>
                            <th scope="col"><i class="ri-arrow-right-up-line"></i>
                                {{ tt_trans('Mark as Read', cons()::LANGUAGE_BACKEND) }}</th>
                        </tr>

                        <x-slot name="tablebody">
                            @forelse (notifications() as $all)
                                <tr class="remove">
                                    <td>
                                        <div class="d-flex align-items-center gap-3">
                                            <span
                                                class="card-icon flex-shrink-0 bg-primary text-white rounded-circle d-flex justify-content-center align-items-center text-xl">
                                                <iconify-icon icon="solar:wallet-linear"></iconify-icon>
                                            </span>
                                            <span
                                                class="d-block flex-grow-1 display-color flex-grow-1 text-line-1 line-height-1">
                                                {{ $all->data['message'] }}
                                                <br>
                                                <span
                                                    class="d-block mt-2 body-color text-xs">{{ dateFormatter($all->created_at) }}</span>
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-check style-checked">
                                            <input class="form-check-input mark"
                                                data-action="{{ route('panel.notification-read', $all->id) }}"
                                                type="checkbox" value="">
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <x-no-data></x-no-data>
                            @endforelse
                        </x-slot>
                    </x-table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {

            'use strict';

            $('.mark').on('click', function() {
                $.ajax({
                    method: "GET",
                    url: $(this).data('action'),
                    success: function(response) {
                        if (response.status) {
                            $.toast({
                                text: response.message,
                                showHideTransition: 'slide',
                                bgColor: 'var(--success)',
                                textColor: '#fff',
                                allowToastClose: true,
                                hideAfter: 5000,
                                stack: 5,
                                textAlign: 'left',
                                position: 'top-right'
                            })
                        }


                    }
                })

                $(this).closest(".remove").remove()
            })
        })
    </script>
@endpush
