@extends('backend.layouts.master')

@section('panel')
    @php
        $versions = getProjectVersions();

        $startingVersion = tc()->get('starting_version');

        foreach ($versions as $version => $data) {
            if (version_compare($version, $startingVersion, '<')) {
                unset($versions[$version]);
            }
        }

    @endphp

    <div class="row justify-content-center">
        <div class="col-xxl-6 col-xl-8 col-lg-10">
            <div class="card">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">

                    <h4 class="card-title mb-0">{{ tt_trans('System Details', cons()::LANGUAGE_BACKEND) }}</h4>

                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between bg-light">
                            <div>
                                <h6 class="mb-0 text-md">{{ tc()->get('sitename') }}</h6>
                                <p class="text-xs mb-0 line-height-1 mt-1">
                                    {{ tt_trans('PHP Version', cons()::LANGUAGE_BACKEND) }} {{ $php_version }}</p>
                            </div>
                            <div class="text-end">
                                <p class="mb-0 line-height-1 text-sm fw-semibold display-color">
                                    {{ tt_trans('Laravel Version', cons()::LANGUAGE_BACKEND) }}</p>
                                <p class="mb-0 text-xs mt-1">{{ $laravel_version }}</p>
                            </div>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
                            <span>{{ tt_trans('Current Project Version', cons()::LANGUAGE_BACKEND) }}</span>
                            <span class="badge badge-light-success">{{ tc()->get('starting_version') }}</span>
                        </li>
                        @if (isUpgradeAvailable())
                            <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
                                <span>{{ tt_trans('Upgradable Version', cons()::LANGUAGE_BACKEND) }}</span>
                                <span
                                    class="badge badge-warning">{{ getProjectVersions()[tc()->get('current_version')]['next_version'] }}</span>
                            </li>
                        @endif
                        <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
                            <span>{{ tt_trans('Timezone', cons()::LANGUAGE_BACKEND) }}</span>
                            <span class="badge badge-light-primary">{{ $timezone }}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
                            <span>{{ tt_trans('Server IP Address', cons()::LANGUAGE_BACKEND) }}</span>
                            <span>{{ $server_ip }}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
                            <span>{{ tt_trans('HTTP Host', cons()::LANGUAGE_BACKEND) }}</span>
                            <span>{{ $host }}</span>
                        </li>

                    </ul>

                    <div class="alert alert-warning mt-5">
                        <h6 class="mb-3">{{ tt_front('Update Guide') }}</h6>
                        <ul>
                            <li>1. {{ tt_front('Click "Upload Update File"') }}</li>
                            <li>2. {{ tt_front('Next click "Update Next Version"') }}</li>
                        </ul>
                    </div>

                    <h6 class="mt-5 text-center">{{ tt_front('All Update Versions') }}</h6>
                    <div class="d-flex flex-wrap justify-content-center gap-3">
                        @forelse ($versions as $key => $version)
                            <div class="system-update-item text-center">
                                <span class="icon">
                                    <iconify-icon icon="fluent-emoji-flat:open-file-folder"></iconify-icon>
                                </span>
                                <span class="version text-dark">{{ $key }}</span>
                                <div>
                                    @if (in_array($key, $updateVersions))
                                        <span class="badge badge-light-success">
                                            {{ tt_trans('Installed') }}
                                        </span>
                                    @else
                                        <span class="badge badge-light-warning">
                                            {{ tt_trans('update') }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                        @empty
                        @endforelse

                    </div>

                    @if (isUpgradeAvailable())
                        <button type="button" class="btn btn-primary mt-4 w-100" data-bs-target="#upload"
                            data-bs-toggle="modal">
                            <i class="ri-folder-zip-line"></i>
                            <span>{{ tt_trans('Upload update file', cons()::LANGUAGE_BACKEND) }}</span>
                        </button>
                    @else
                        <p class="text-center mt-3 alert alert-success d-flex align-items-center justify-content-center gap-2">
                            <span class="text-xxl line-height-1">
                                <iconify-icon icon="fluent:phone-update-checkmark-20-regular"></iconify-icon>
                            </span>
                            {{tt_trans('Your system is up to date',cons()::LANGUAGE_BACKEND)}}
                        </p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <x-modal id="upload" title="Upload update file" size="">
        <form action="{{ route('panel.upload-file') }}" method="post" enctype="multipart/form-data">
            @csrf

            <p class="alert alert-danger text-sm">
                <i class="ri-file-warning-line"></i>
                {{ tt_front('Please do not upload previous version or current version zip file') }}
            </p>

            <label for="" class="form-label">{{ tt_front('Upload File') }}</label>

            <input type="file" name="file" class="form-control" required accept=".zip">

            <button type="submit" class="btn btn-danger mt-4">{{ tt_trans('Upload', cons()::LANGUAGE_BACKEND) }}</button>
        </form>
    </x-modal>
@endsection
