@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.page.store') }}">
        @csrf
        <div class="row gy-4">
            <div class="col-xxl-7">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title mb-0">{{ tt_trans('Page Information') }}</h4>
                        <button class="btn btn-sm btn-primary addDescription"><i
                                class="fa fa-plus me-2"></i>{{ tt_trans('Add Description', cons()::LANGUAGE_BACKEND) }}</button>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-lg-6">
                                <label class="form-label">{{ tt_trans('Page name', cons()::LANGUAGE_BACKEND) }}</label>
                                <input type="text" name="name" class="form-control"
                                    placeholder="{{ tt_back('Enter Page Name') }}">
                            </div>
                            <div class="col-lg-6" id="appear">
                                <label class="form-label">{{ tt_trans('Page status', cons()::LANGUAGE_BACKEND) }}</label>
                                <select class="form-select" name="status">
                                    <option value="{{ cons()::ACTIVE }}">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}
                                    </option>
                                    <option value="{{ cons()::INACTIVE }}">
                                        {{ tt_trans('Disable', cons()::LANGUAGE_BACKEND) }}</option>
                                </select>
                            </div>




                            <div class="col-lg-12">
                                <label class="form-label">{{ tt_trans('Seo keywords', cons()::LANGUAGE_BACKEND) }}</label>
                                <select class="form-select-two form-select-two-tokenizer" multiple="multiple"
                                    name="seo_keywords[]">
                                </select>
                            </div>
                            <div class="col-lg-12">
                                <label
                                    class="form-label">{{ tt_trans('Seo description', cons()::LANGUAGE_BACKEND) }}</label>
                                <textarea name="seo_description" class="form-control" cols="12" rows="6"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


         

            <div class="col-xxl-5">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Section Management', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <select class="form-select bg-light-light mb-4" id="sectionSelect">
                            <option selected>{{ tt_trans('Select Section', cons()::LANGUAGE_BACKEND) }}</option>
                            @foreach ($sections as $key => $section)
                                <option value="{{ $key }}">{{ $section }}</option>
                            @endforeach

                        </select>

                        <ul id="sortable"
                            class="sections-list p-3 bg-light-primary border border-2 border-dashed border-light-primary rounded">

                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <button type="submit"
                class="btn btn-primary mt-4">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
        </div>
    </form>
@endsection
@push('style')
    <link rel="stylesheet" href="{{ css('select2.min.css', cons()::ASSETS_FROM_COMMON) }}">
@endpush

@push('script')
    <script src="{{ js('select2.min.js', cons()::ASSETS_FROM_COMMON) }}"></script>
    <script>
        $(function() {
            'use strict'


            let description = `
                     <div class="col-lg-12" id="removeEditor">
                        <x-ai name="description" target="description" type="editor" label="Description"></x-ai>

                        <button class="btn text-danger delete"><i class="fa fa-times me-1"></i>{{ tt_trans('Delete', cons()::LANGUAGE_BACKEND) }}</button>
                    </div>
                `;

            $(document).on('click', '.delete', function(e) {
                e.preventDefault()
                $(this).closest('#removeEditor').remove()
            })

            $('.addDescription').on('click', function(e) {

                e.preventDefault();
                if ($('#removeEditor').length === 0) {

                    $('#appear').after(description);

                    $('.summernote').each(function(i) {
                        new nicEditor().panelInstance($(this)[0]);
                    })
                }
            });

            $(".form-select-two-tokenizer").select2({
                tags: true,
                tokenSeparators: [',', ' ']
            })


            $('[data-toggle="dropdown"]').each(function() {
                $(this).attr('data-bs-toggle', 'dropdown');
                $(this).removeAttr('data-toggle');
            });


            $("#sortable").sortable();
            $("#sortable").disableSelection();
            // Append selected option to sortable list
            $('#sectionSelect').change(function() {
                var selectedOption = $(this).val();
                var selectedOptionvalue = $('#sectionSelect option:selected').val();
                var selectedOptionText = $('#sectionSelect option:selected').text();
                if (selectedOption) {
                    $('#sortable').append(`
                    <li class="single-item py-2 px-3 bg-white rounded shadow-xs d-flex align-items-center gap-2">
                        <span class="text-lg text-primary">
                            <iconify-icon icon="oui:sortable"></iconify-icon>
                        </span>
                        <input name="sections[]" type="hidden" value="${selectedOptionvalue}">
                        <span>${selectedOptionText}</span>
                        <button type="button" class="p-1 py-0 text-xl text-danger ms-auto item-remove-btn">
                            <i class="ri-close-line"></i>
                        </button>
                    </li>
                `);
                    $(this).prop('selectedIndex', 0);
                }
            });

            $(document).on('click', '.item-remove-btn', function() {
                $(this).closest('.single-item').remove();
            });


        })
    </script>
@endpush
\