@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">

            <h4 class="card-title mb-0">{{ tt_trans('All Pages', cons()::LANGUAGE_BACKEND) }}</h4>
            <div>
                <a class="btn btn-sm btn-primary" href="{{ route('panel.page.create') }}">
                    <i class="ri-add-circle-line"></i> {{ tt_trans('Add New Page', cons()::LANGUAGE_BACKEND) }}
                </a>
                <a class="btn btn-sm btn-secondary" href="{{ route('panel.menu') }}">
                    <i class="ri-add-circle-line"></i> {{ tt_trans('Build Menu', cons()::LANGUAGE_BACKEND) }}
                </a>
            </div>
        </div>
        <div class="card-body">
            <x-table :paginations="$pages">
                <tr>
                    <th scope="col"><i class="ri-profile-line"></i>{{ tt_trans('Page Name', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-file-list-3-line"></i>{{ tt_trans('Slug', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-profile-line"></i> {{ tt_trans('Sections', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse ($pages as $page)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <div>
                                        <h6 class="text-sm mb-1">{{ $page->name }}</h6>
                                        <p class="text-xs mb-0 line-height-1 text-muted">
                                            {{ tt_trans('Created at', cons()::LANGUAGE_BACKEND) }}
                                            {{ dateFormatter($page->created_at) }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <p class="mb-0">{{ $page->slug }}</p>
                            </td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    @foreach ($page->sections as $section)
                                        <span class="badge badge-light">{{ $section->name }}</span>
                                    @endforeach

                                </div>
                            </td>
                            <td>
                                <?= status($page) ?>
                            </td>
                            <td>
                                <a href="{{ route('panel.page.edit', $page->id) }}"
                                    class="btn btn-icon rounded-circle btn-primary">
                                    <i class="ri-edit-line"></i>
                                </a>

                                @if (!$page->is_default)
                                    <x-delete-button :action="route('panel.page.destroy', $page->id)"></x-delete-button>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse

                </x-slot>
            </x-table>
        </div>
    </div>
@endsection
