<aside class="sidebar">
    <div class="sidebar-logo-area">
        <a href="{{ route('panel.dashboard') }}" class="sidebar-logo">
            {{ tc()->get('sitename') }}
        </a>
        <button type="button" class="sidebar-collapse-btn"></button>
        <button type="button" class="sidebar-close-btn"></button>
    </div>
    <div class="sidebar-menu-area">
        <form class="sidebar-search">
            <input type="text" name="search" placeholder="{{tt_trans('Search',cons()::LANGUAGE_BACKEND)}}" id="search-input" autocomplete="off">
            <iconify-icon icon="ion:search-outline" class="icon"></iconify-icon>
        </form>
        <ul class="sidebar-menu" id="sidebar-menu">
            <li>
                <a href="{{ route('panel.dashboard') }}">
                    <iconify-icon icon="solar:home-smile-linear" class="sidebar-menu-icon"></iconify-icon>
                    <span>{{ tt_trans('Dashboard', cons()::LANGUAGE_BACKEND) }}</span>
                </a>
            </li>
            @if (admin()->can('manage_currency'))
                <li>
                    <a href="{{ route('panel.currency.index') }}">
                        <iconify-icon icon="mdi:dollar" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Currency', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_ico_setting'))
                <li>
                    <a href="{{ route('panel.ico.setting') }}">
                        <iconify-icon icon="weui:setting-filled" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Ico Setting', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_stage'))
                <li>
                    <a href="{{ route('panel.stage.index') }}">
                        <iconify-icon icon="mynaui:box" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Stage', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_stage'))
                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="icon-park-outline:log" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Stage Log', cons()::LANGUAGE_BACKEND) }}
                        </span>
                    </a>
                    <ul class="sidebar-submenu">
                        <li>
                            <a
                                href="{{ route('panel.stage.purchases') }}">{{ tt_trans('All Purchase', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>

                        <li>
                            <a href="{{ route('panel.offline-completed-purchase') }}">{{ tt_trans('Completed Purchases', cons()::LANGUAGE_BACKEND) }}

                            </a>
                        </li>
                        <li>
                            <a href="{{ route('panel.offline-pending-purchase') }}">{{ tt_trans('Pending Purchases', cons()::LANGUAGE_BACKEND) }}

                                @if (pendingPaymentCounter() > 0)
                                    <span class="badge badge-danger ms-2">{{ pendingPaymentCounter() }}</span>
                                @endif
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('panel.offline-reject-purchase') }}">{{ tt_trans('Reject Purchases', cons()::LANGUAGE_BACKEND) }}

                            </a>
                        </li>

                    </ul>
                </li>
            @endif
            @if (admin()->can('manage_auction'))
                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="ph:stack-plus" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Auctions', cons()::LANGUAGE_BACKEND) }}
                        </span>
                    </a>
                    <ul class="sidebar-submenu">
                        <li>
                            <a href="{{ route('panel.auction.history') }}">{{ tt_trans('Auction History', cons()::LANGUAGE_BACKEND) }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('panel.auction.running') }}">{{ tt_trans('Running Auction', cons()::LANGUAGE_BACKEND) }}
                            </a>
                        </li>
                    </ul>
                </li>
            @endif



            <?= getModuleSidebarMenus()?>




            @if (admin()->can('manage_users') || admin()->can('manage_kyc_request'))
                <li class="sidebar-menu-group-title">{{ tt_trans('User Management', cons()::LANGUAGE_BACKEND) }}
                </li>
            @endif

            @if (admin()->can('manage_users'))
                <li>
                    <a href="{{ route('panel.users') }}">
                        <iconify-icon icon="la:user-cog" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Users', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_users'))
                <li>
                    <a href="{{ route('panel.user-logins-report') }}">
                        <iconify-icon icon="hugeicons:user-group" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('User logins', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_kyc_request'))
                <li>
                    <a href="{{ route('panel.kyc-verification-request') }}">
                        <iconify-icon icon="hugeicons:user-id-verification" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Kyc Verifications', cons()::LANGUAGE_BACKEND) }}</span>
                        <span
                            class="badge badge-light ms-auto">{{ \App\Models\KycRequest::where('status', cons()::PENDING)->count() }}</span>
                    </a>
                </li>
            @endif



            @if (admin()->can('manage_deposits') || admin()->can('manage_withdraw'))
                <li class="sidebar-menu-group-title">{{ tt_trans('Transaction Management', cons()::LANGUAGE_BACKEND) }}
                </li>
            @endif



            @if (admin()->can('manage_deposits'))

                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="solar:card-2-broken" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Deposits', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                    <ul class="sidebar-submenu">
                        <li>
                            <a href="{{ route('panel.offline-deposits') }}">{{ tt_trans('Offline Deposits', cons()::LANGUAGE_BACKEND) }}

                                @if (pendingDepositCounter() > 0)
                                    <span class="badge badge-danger ms-2">{{ pendingDepositCounter() }}</span>
                                @endif
                            </a>
                        </li>
                        <li>
                            <a
                                href="{{ route('panel.online-deposits') }}">{{ tt_trans('Online Deposits', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                    </ul>
                </li>
            @endif


            @if (admin()->can('manage_withdraw'))
                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="iconoir:hand-cash" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Withdraw', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                    <ul class="sidebar-submenu">

                        <li>
                            <a
                                href="{{ route('panel.withdraw-request') }}">{{ tt_trans('All Withdraws', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                        <li>
                            <a
                                href="{{ route('panel.withdraw-request', ['sort' => 'pending']) }}">{{ tt_trans('Pending Withdraws', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                        <li>
                            <a
                                href="{{ route('panel.withdraw-request', ['sort' => 'accepted']) }}">{{ tt_trans('Accepted Withdraws', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                        <li>
                            <a
                                href="{{ route('panel.withdraw-request', ['sort' => 'rejected']) }}">{{ tt_trans('Rejected Withdraws', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                    </ul>
                </li>
            @endif


            @if (admin()->can('manage_settings') ||
                    admin()->can('manage_email') ||
                    admin()->can('manage_gateways') ||
                    admin()->can('manage_withdraw') ||
                    admin()->can('manage_referral'))
                <li class="sidebar-menu-group-title">{{ tt_trans('Site Configuration', cons()::LANGUAGE_BACKEND) }}
                </li>
            @endif

            @if (admin()->can('manage_settings'))
                <li>
                    <a href="{{ route('panel.settings') }}">
                        <iconify-icon icon="solar:settings-broken" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Site Settings', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_email'))
                <li>
                    <a href="{{ route('panel.email.config') }}">
                        <iconify-icon icon="hugeicons:mail-setting-01" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Email Config', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_withdraw'))
                <li>
                    <a href="{{ route('panel.withdraw.index') }}">
                        <iconify-icon icon="fluent-emoji-high-contrast:money-with-wings"
                            class="sidebar-menu-icon"></iconify-icon>
                        <span>
                            {{ tt_trans('Withdraw Methods', cons()::LANGUAGE_BACKEND) }}
                        </span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_gateways'))
                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="solar:card-broken" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Payment Gateways', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                    <ul class="sidebar-submenu">
                        <li>
                            <a
                                href="{{ route('panel.gateways') }}">{{ tt_trans('Online Gateways', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                        <li>
                            <a
                                href="{{ route('panel.offline-gateways') }}">{{ tt_trans('Offline Gateways', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                    </ul>
                </li>
            @endif


            @if (admin()->can('manage_referral'))
                <li>
                    <a href="{{ route('panel.referral-settings') }}">
                        <iconify-icon icon="carbon:network-3-reference" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Referral', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_role') || admin()->can('manage_staffs'))
                <li class="sidebar-menu-group-title">{{ tt_trans('Administration', cons()::LANGUAGE_BACKEND) }}</li>
            @endif

            @if (admin()->can('manage_role'))
                <li>
                    <a href="{{ route('panel.roles.index') }}">
                        <iconify-icon icon="carbon:user-role" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Roles', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_staffs'))
                <li>
                    <a href="{{ route('panel.admins.index') }}">
                        <iconify-icon icon="clarity:administrator-line" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Admins', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_reports'))
                <li class="sidebar-menu-group-title">{{ tt_trans('Reports', cons()::LANGUAGE_BACKEND) }}</li>
            @endif

            @if (admin()->can('manage_reports'))
                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="fluent-mdl2:text-document-settings"
                            class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Reports', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                    <ul class="sidebar-submenu">


                        <li>
                            <a
                                href="{{ route('panel.transactions-report') }}">{{ tt_trans('Transactions Report', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>


                        <li>
                            <a
                                href="{{ route('panel.referral-commission-report') }}">{{ tt_trans('Commission Report', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>


                        <li>
                            <a
                                href="{{ route('panel.user-earnings-report') }}">{{ tt_trans('Earnings Report', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>



                    </ul>
                </li>
            @endif



            @if (admin()->can('manage_theme') ||
                    admin()->can('manage_language') ||
                    admin()->can('manage_pages') ||
                    admin()->can('manage_menus') ||
                    admin()->can('manage_blogs') ||
                    admin()->can('manage_frontend'))
                <li class="sidebar-menu-group-title">{{ tt_trans('Theme Settings', cons()::LANGUAGE_BACKEND) }}</li>
            @endif


            @if (admin()->can('manage_theme'))
                <li>
                    <a href="{{ route('panel.theme') }}">
                        <iconify-icon icon="ep:brush" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Themes', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif


            @if (admin()->can('manage_pages'))
                <li>
                    <a href="{{ route('panel.page.index') }}">
                        <iconify-icon icon="iconoir:multiple-pages" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Pages', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif


            @if (admin()->can('manage_menus'))
                <li>
                    <a href="{{ route('panel.menu') }}">
                        <iconify-icon icon="bi:menu-button-wide" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Menu Builder', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_frontend'))
                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="fluent:content-view-16-regular" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Frontend Content', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                    <ul class="sidebar-submenu">
                        @foreach (sections()['sections'] as $key => $sectionItem)
                            <li>
                                <a
                                    href="{{ route('panel.content', $key) }}">{{ tt_trans($sectionItem, cons()::LANGUAGE_BACKEND) }}</a>
                            </li>
                        @endforeach

                    </ul>
                </li>
            @endif

            @if (admin()->can('manage_blogs'))
                <li class="dropdown">
                    <a href="javascript:void(0)">
                        <iconify-icon icon="carbon:blog" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Blogs', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                    <ul class="sidebar-submenu">
                        <li>
                            <a
                                href="{{ route('panel.blog-category.index') }}">{{ tt_trans('Blog Category', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                        <li>
                            <a
                                href="{{ route('panel.blogs.index') }}">{{ tt_trans('Blogs', cons()::LANGUAGE_BACKEND) }}</a>
                        </li>
                    </ul>
                </li>
            @endif




            @if (admin()->can('manage_language'))
                <li>
                    <a href="{{ route('panel.language.index') }}">
                        <iconify-icon icon="iconoir:language" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Manage Language', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif




            <li class="sidebar-menu-group-title">{{ tt_trans('Others', cons()::LANGUAGE_BACKEND) }}</li>

            @if (admin()->can('manage_support'))
                <li>
                    <a href="{{ route('panel.contact') }}">
                        <iconify-icon icon="fluent:person-support-20-regular"
                            class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Contact', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif



            @if (admin()->can('manage_support'))
                <li>
                    <a href="{{ route('panel.support') }}">
                        <iconify-icon icon="ic:outline-contact-support" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Support Tickets', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_notifications'))
                <li>
                    <a href="{{ route('panel.notifications') }}">
                        <iconify-icon icon="iconoir:bell-notification" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Notifications', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_subscribers'))
                <li>
                    <a href="{{ route('panel.subscribers') }}">
                        <iconify-icon icon="fluent:person-mail-32-regular" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('Subscribers', cons()::LANGUAGE_BACKEND) }}</span>
                    </a>
                </li>
            @endif

            @if (admin()->can('manage_version'))
                <li>
                    <a href="{{ route('panel.system-version') }}">
                        <iconify-icon icon="octicon:versions-24" class="sidebar-menu-icon"></iconify-icon>
                        <span>{{ tt_trans('System Version', cons()::LANGUAGE_BACKEND) }}</span>
                        @if (isUpgradeAvailable())
                            <span class="text-warning ms-auto"><i class="ri-error-warning-fill m-0"></i></span>
                        @endif
                    </a>
                </li>
            @endif


            <li>
                <a href="{{ route('panel.addons') }}">
                    <iconify-icon icon="octicon:versions-24" class="sidebar-menu-icon"></iconify-icon>
                    <span>{{ tt_trans('Install Addons', cons()::LANGUAGE_BACKEND) }}</span>
                    @if (isUpgradeAvailable())
                        <span class="text-warning ms-auto"><i class="ri-error-warning-fill m-0"></i></span>
                    @endif
                </a>
            </li>

            <li>
                <a href="{{ route('panel.clear-cache') }}">
                    <iconify-icon icon="ph:broom" class="sidebar-menu-icon"></iconify-icon>
                    <span>{{ tt_trans('Cache Clear', cons()::LANGUAGE_BACKEND) }}</span>
                </a>
            </li>


        </ul>
    </div>
</aside>
