<div class="navbar-header">
    <div class="row gx-sm-4 gx-3 align-items-center justify-content-between">
        <div class="col-auto d-xl-none">
            <button type="button" class="sidebar-mobile-open-btn fw-bold display-color text-xl">
                <i class="ri-bar-chart-horizontal-line"></i>
            </button>
        </div>
        <div class="col-auto me-auto">
            <div class="d-md-block d-none">
                <h6 class="text-xl mb-0">{{ tt_trans('Dashboard', cons()::LANGUAGE_BACKEND) }}</h6>
                <ul class="navbar-breadcrumb ">
                    <li>
                        <a
                            href="{{ route('panel.dashboard') }}">{{ tt_trans('Dashboard', cons()::LANGUAGE_BACKEND) }}</a>
                    </li>

                    @php
                        $property_array = explode(' ', str_replace(['.', '-'], ' ', request()->route()->getName()));
                        $new_array = array_shift($property_array);
                    @endphp

                    @if (!request()->routeIs('panel.dashboard'))
                        <li>{{ tt_trans(ucfirst(implode(' ', $property_array)), cons()::LANGUAGE_BACKEND) }}</li>
                    @endif
                </ul>
            </div>
            <div class="d-md-none d-block">
                <h6 class="text-sm mb-0 w-150px">
                    {{ tt_trans(ucfirst(implode(' ', $property_array)), cons()::LANGUAGE_BACKEND) }}</h6>
            </div>
        </div>
        <div class="col-auto">
            <div class="d-flex flex-wrap align-items-center gap-sm-3 gap-2">
               
                <a href="{{ route('home') }}" target="_blank" class="action-icon rounded-circle"
                    data-bs-toggle="tooltip" data-bs-title="{{tt_trans('Visit Home Page',cons()::LANGUAGE_BACKEND)}}" target="_blank">
                    <iconify-icon icon="carbon:home" class="text-primary-light text-xl"></iconify-icon>
                </a>
                <div class="dropdown d-none d-sm-inline-block">
                    <button class="action-icon rounded-circle" type="button" data-bs-toggle="dropdown">
                        <iconify-icon icon="iconoir:language" class="text-primary-light text-xl"></iconify-icon>
                    </button>
                    <ul class="dropdown-menu language-dropdown-menu">
                        <li>
                            <a class="dropdown-item {{ currentLanguage('en') }} d-flex align-items-center gap-2"
                                href="{{ route('language-switch', 'en') }}">
                                <img src="{{ getFile('common', 'en.png') }}" alt="language image"
                                    class="avatar-xs rounded-circle">
                                {{ tt_trans('English') }}
                            </a>
                        </li>

                        @foreach (languages() as $lang)
                            <li>
                                <a class="dropdown-item {{ currentLanguage($lang->code) }} d-flex align-items-center gap-2"
                                    href="{{ route('language-switch', $lang->code) }}">
                                    <img src="{{ getFile('language', $lang->image) }}" alt="language image"
                                        class="avatar-xs rounded-circle">
                                    {{ tt_trans($lang->name,cons()::LANGUAGE_BACKEND) }}
                                </a>
                            </li>
                        @endforeach

                    </ul>
                </div><!-- Language dropdown end -->

                <div class="dropdown">
                    <button class="action-icon rounded-circle {{ notifications()->count() > 0 ? 'has-pulse' : '' }}"
                        type="button" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                        <iconify-icon icon="iconoir:bell" class="text-primary-light text-xl"></iconify-icon>
                        <span class="pulse-circle"></span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                        <div class="px-3 pt-2 pb-3 border-bottom">
                            <h6 class="text-md mb-0">{{ tt_trans('Notifications', cons()::LANGUAGE_BACKEND) }}</h6>
                        </div>


                        <div class="tab-content mt-0" id="myTabContent">
                            <div class="tab-pane fade show active" id="tab1-tab-pane" role="tabpanel"
                                aria-labelledby="tab1-tab" tabindex="0">
                                <ul class="max-h-300">
                                    @forelse (notifications() as $noti)
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center gap-3 py-3"
                                                href="{{ $noti->data['url'] }}">
                                                <span
                                                    class="card-icon flex-shrink-0 bg-info text-white rounded-circle d-flex justify-content-center align-items-center text-xl">
                                                    <iconify-icon icon="solar:cash-out-outline"></iconify-icon>
                                                </span>
                                                <span
                                                    class="d-block flex-grow-1 display-color flex-grow-1 text-line-1 line-height-1">
                                                    {{ $noti->data['message'] }}
                                                    <br>
                                                    <span
                                                        class="d-block mt-2 body-color text-xs">{{ dateFormatter($noti->created_at) }}</span>
                                                </span>
                                            </a>
                                        </li>
                                    @empty
                                        <div class="no-data-wrapper text-center p-4">
                                            <img src="{{ getFile('common', 'no-data-sm.png') }}"
                                                alt="image" class="no-data-img">
                                            <h6 class="mt-4 mb-0 text-md">
                                                {{ tt_trans("Haven't any notification yet", cons()::LANGUAGE_BACKEND) }}
                                            </h6>
                                        </div>
                                    @endforelse
                                </ul>
                            </div>
                        </div>

                        <div class="d-flex align-items-center justify-content-between gap-3 px-3 pt-2 border-top">
                            <a href="{{ route('panel.mark-as-all-read') }}" class="text-sm text-primary"><i
                                    class="ri-check-double-line"></i>
                                {{ tt_trans('Mark all as read', cons()::LANGUAGE_BACKEND) }}</a>
                            <a href="{{ route('panel.notifications') }}"
                                class="btn btn-sm btn-light-primary">{{ tt_trans('View All', cons()::LANGUAGE_BACKEND) }}
                                <i class="ri-arrow-right-line"></i></a>
                        </div>
                    </div>
                </div><!-- Notification dropdown end -->

                <div class="dropdown border-start ps-sm-3 ps-2">
                    <button class="d-inline-flex flex-wrap align-items-center gap-2 nav-admin-profile" type="button"
                        data-bs-toggle="dropdown">
                        <img src="{{ getFile('staff', admin()->image) }}" alt="image"
                            class="avatar-lg rounded-circle">
                        <span class="d-sm-block d-none text-sm line-height-1">
                            <b>{{ admin()->email }}</b>
                            <span class="d-flex align-items-center gap-1 line-height-1 text-xs text-muted mt-1">
                                {{ admin()->username }}
                                <i class="ri-arrow-down-s-line"></i>
                            </span>
                        </span>
                    </button>
                    <ul class="dropdown-menu">
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-2"
                                href="{{ route('panel.admin-profile') }}">
                                <iconify-icon icon="hugeicons:user-circle-02"></iconify-icon>
                                {{ tt_trans('Profile', cons()::LANGUAGE_BACKEND) }}
                            </a>
                        </li>
                        @if (admin()->can('manage_settings'))
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-2"
                                    href="{{ route('panel.settings') }}">
                                    <iconify-icon icon="solar:settings-linear"></iconify-icon>
                                    {{ tt_trans('Settings', cons()::LANGUAGE_BACKEND) }}
                                </a>
                            </li>
                        @endif
                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-2"
                                href="{{ route('panel.logout') }}">
                                <iconify-icon icon="ant-design:logout-outlined"></iconify-icon>
                                {{ tt_trans('Logout', cons()::LANGUAGE_BACKEND) }}
                            </a>
                        </li>
                    </ul>
                </div><!-- Profile dropdown end -->
            </div>
        </div>
    </div>
</div>
