@extends('backend.layouts.master')

@section('panel')
    <div class="row">

        <div class="col-12 col-md-12 col-lg-12">
            <div class="card">

                <div class="card-body text-center">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <span>{{ __('Transaction Id') }}</span>
                            <span>{{ $payment->trx }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <span>{{ __('Payment Date') }}</span>
                            <span>{{ dateFormatter($payment->created_at) }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <span>{{ __('Total Payment') }}</span>
                            <span>{{ $payment->total_price }} {{ $payment->currency->name }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <span>{{ __('Token') }}</span>
                            <span>{{ $payment->token }} {{ $setting->token_symbol }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <span>{{ __('Bonus') }}</span>
                            <span>{{ $payment->bonus_token }} {{ $setting->token_symbol }}</span>
                        </li>

                        @if ($payment->payment_proof)
                            @foreach ($payment->payment_proof as $key => $proof)
                                @if (is_array($proof))
                                    <li class="list-group-item d-flex justify-content-between">

                                        <span>{{ __(str_replace('_', ' ', ucwords($key))) }}</span>
                                        <span class="text-right"><img
                                                src="{{ Config::getFile('manual_payment', $proof['file']) }}"
                                                alt="" class="w-50 "></span>

                                    </li>

                                    @continue
                                @endif

                                <li class="list-group-item d-flex justify-content-between">

                                    <span>{{ __(str_replace('_', ' ', ucwords($key))) }}</span>
                                    <span>{{ __($proof) }}</span>

                                </li>
                            @endforeach
                        @endif

                        @if ($payment->status == 3)
                            <li class="list-group-item d-flex justify-content-between">

                                <span class="font-weight-bolder">{{ __('Reject Reason') }}</span>
                                <span>{{ $payment->note }}</span>

                            </li>
                        @endif

                    </ul>

                    @if ($payment->status == cons()::PENDING)
                        <div class="d-flex align-items-center gap-2 mt-4 float-end">
                            <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal"
                                data-bs-target="#accept"><i class="ri-check-line"></i>
                                {{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                data-bs-target="#reject"><i class="ri-close-line"></i>
                                {{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>


    <x-modal id="accept" title="Accept Payment Request" size="">
        <div class="d-flex flex-column justify-content-center align-items-center text-center">
            <div class="card-icon-lg bg-light-danger text-danger text-2xl item-center rounded-circle">
                <iconify-icon icon="ant-design:alert-outlined"></iconify-icon>
            </div>
            <h5 class="mt-4">{{ tt_trans('Are You Sure', cons()::LANGUAGE_BACKEND) }}?</h5>
            <p class="text-muted mb-0">{{ tt_trans('This will', cons()::LANGUAGE_BACKEND) }} <span
                    class="text-danger">{{ tt_trans('Verify Payment request', cons()::LANGUAGE_BACKEND) }}</span>.
                {{ tt_trans("You can't undo this action.", cons()::LANGUAGE_BACKEND) }}.
            </p>

            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <form action="{{ route('panel.offline-purchase-accept', $payment->id) }}" method="post">
                    @csrf
                    <button type="submit"
                        class="btn btn-success">{{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                </form>
            </div>


        </div>



    </x-modal>



    <x-modal id="reject" title="Reject Payment Request" size="" :isHeader="false">
        <form action="{{ route('panel.offline-purchase-reject', $payment->id) }}" method="post">
            @csrf
            <h5 class="mb-1">{{ tt_trans('Deny this payment', cons()::LANGUAGE_BACKEND) }}</h5>
            <p class="text-warning text-sm">
                {{ tt_trans('Do you really wan to reject this payment', cons()::LANGUAGE_BACKEND) }}?</p>
            <div class="mt-4">
                <label class="form-label">{{ tt_trans('Reason of reject', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea name="reason" class="form-control" rows="6" cols="12"></textarea>
            </div>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <button type="submit" class="btn btn-danger">{{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </form>

    </x-modal>

@endsection

@push('script')
    <link rel="stylesheet" href="{{ css('magnific-popup.css') }}">
@endpush

@push('script')
    <script src="{{ js('magnifc-popup.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            'use strict'
            $('.image-view').magnificPopup({
                type: 'image'
            });

        });
    </script>
@endpush
