@extends('backend.layouts.master')

@section('panel')

<div class="row justify-content-center">
    <div class="col-xxl-8">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4">{{tt_trans('Profile Update',cons()::LANGUAGE_BACKEND)}}</h4>
                <form method="POST" action="{{route('panel.admin-profile-update')}}" enctype="multipart/form-data">
                    @csrf
                    <div class="row gy-4 align-items-center">
                        <div class="col-lg-4">
                            <div class="image-upload">
                                <div class="image-preview">
                                    <div class="singleImage" style="background-image: url({{getFile('staff', admin()->image)}});">
                                    </div>
                                </div>
                                <div class="image-edit-btn">
                                    <input type='file' name="image" class="singleImageUpload" id="image1" accept=".png, .jpg, .jpeg" />
                                    <label for="image1" data-text="Upload"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="row gy-4">
                                <div class="col-md-6">
                                    <label class="form-label">{{tt_trans('Username',cons()::LANGUAGE_BACKEND)}}</label>
                                    <input type="text" name="username" class="form-control" placeholder="Enter Username" value="{{admin()->username}}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">{{tt_trans('Email',cons()::LANGUAGE_BACKEND)}}</label>
                                    <input type="email" name="email" class="form-control" placeholder="Enter Email Address" value="{{admin()->email}}">
                                </div>
                                <div class="col-12 text-end">
                                    <button type="submit" class="btn btn-primary">{{tt_trans('Save Changes',cons()::LANGUAGE_BACKEND)}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <hr class="my-4">

                <h4 class="card-title mb-4">{{tt_trans('Password Settings',cons()::LANGUAGE_BACKEND)}}</h4>
                <form method="POST" action="{{route('panel.admin-password-update')}}">
                    @csrf
                    <div class="row gy-4">
                        <div class="col-lg-12">
                            <label class="form-label">{{tt_trans('Old Password',cons()::LANGUAGE_BACKEND)}}</label>
                            <input type="password" name="old_password" class="form-control" placeholder="Enter Old Password">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">{{tt_trans('New Password',cons()::LANGUAGE_BACKEND)}}</label>
                            <input type="password" name="password" class="form-control" placeholder="Enter New Password">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">{{tt_trans('Confirm Password',cons()::LANGUAGE_BACKEND)}}</label>
                            <input type="password" name="password_confirmation" class="form-control" placeholder="Enter Confirm Password">
                        </div>
                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-primary">{{tt_trans('Save Changes',cons()::LANGUAGE_BACKEND)}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
