@extends('backend.layouts.master')

@section('panel')
    <div class="row gy-4">
        @foreach ($settings as $setting)
            <div class="col-xxl-6">
                <div class="card h-100">
                    <div class="card-header d-flex flex-wrap gap-2 align-items-center justify-content-between">
                        <div class="d-flex flex-wrap gap-2 align-items-center">
                            <h4 class="card-title mb-0">
                                {{ tt_trans(ucwords(str_replace('_',' ',$setting->name)) . ' Referral', cons()::LANGUAGE_BACKEND) }}
                            </h4>
                            <?= status($setting, 'light-') ?>
                        </div>
                        <div class="d-flex gap-2 align-items-center">
                            <button type="button" class="btn btn-sm btn-light settings" data-setting="{{ $setting->name }}" data-status="{{$setting->status}}" data-type="{{$setting->type}}"
                                data-bs-toggle="modal" data-bs-target="#referralSettingModal">
                                <i class="ri-settings-3-line"></i> {{ tt_trans('Settings', cons()::LANGUAGE_BACKEND) }}
                            </button>
                            <button type="button" class="btn btn-sm btn-primary add" data-setting="{{ $setting->id }}" data-bs-toggle="modal"
                                data-bs-target="#addReferralModal">
                                <i class="ri-add-circle-line"></i> {{ tt_trans('Add New', cons()::LANGUAGE_BACKEND) }}
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <x-table>
                            <tr>
                                <th scope="col"><i
                                        class="ri-bar-chart-2-line"></i>{{ tt_trans('Level No', cons()::LANGUAGE_BACKEND) }}.
                                </th>
                                <th scope="col"><i
                                        class="ri-percent-line"></i>{{ tt_trans('Commission', cons()::LANGUAGE_BACKEND) }}
                                </th>
                                <th scope="col"><i
                                        class="ri-function-line"></i>{{ tt_trans('Referral type', cons()::LANGUAGE_BACKEND) }}
                                </th>
                                <th scope="col"><i
                                        class="ri-arrow-right-up-line"></i>{{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}
                                </th>
                            </tr>

                            <x-slot name="tablebody">
                                @forelse ($setting->levels as $level)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="card-icon flex-shrink-0 rounded-circle">
                                                    <img src="{{getFile('referral', $level->image)}}" alt="image" class="w-100 h-100 object-fit-cover rounded-circle">
                                                </div>
                                                <div>
                                                    <h6 class="text-sm mb-0">{{ $level->name }}</h6>
                                                    <p class="text-xs mb-0 line-height-1 text-muted">
                                                        {{ dateFormatter($level->created_at) }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            {{ commissionFormatter($setting, $level) }}
                                        </td>
                                        <td>
                                            @if ($setting->type == cons()::FIXED)
                                                <span
                                                    class="badge badge-light-primary">{{ tt_trans('Fixed', cons()::LANGUAGE_BACKEND) }}</span>
                                            @else
                                                <span
                                                    class="badge badge-light-info">{{ tt_trans('Percent', cons()::LANGUAGE_BACKEND) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap align-items-center gap-2">
                                                <button type="button" class="btn btn-icon btn-primary rounded-circle edit"
                                                    data-bs-toggle="modal" data-bs-target="#editReferralModal" data-action="{{route('panel.referral-level-update', $level->id)}}" data-setting="{{ $setting->id }}" data-name="{{$level->name}}" data-commission="{{formatter($level->commission)}}">
                                                    <i class="ri-edit-line"></i>
                                                </button>
                                                <button type="button" class="btn btn-icon btn-danger rounded-circle delete"
                                                    data-bs-toggle="modal" data-bs-target="#delete" data-action="{{route('panel.referral-level-delete', $level->id)}}">
                                                    <i class="ri-delete-bin-line"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <x-no-data></x-no-data>
                                @endforelse

                            </x-slot>
                        </x-table>

                    </div>
                </div>
            </div>
        @endforeach

    </div>

    <x-modal id="referralSettingModal" title="Referral Setting" size="">
        <form method="POST">
            @csrf
            <input type="hidden" name="name" value="">
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Referral status', cons()::LANGUAGE_BACKEND) }}</label>
                <select class="form-select" name="status">
                    <option value="{{ cons()::ACTIVE }}">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                    <option value="{{ cons()::INACTIVE }}">{{ tt_trans('Deactivate', cons()::LANGUAGE_BACKEND) }}</option>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Level commission type', cons()::LANGUAGE_BACKEND) }}</label>
                <select class="form-select" name="type">
                    <option value="{{ cons()::FIXED }}">{{ tt_trans('Fixed', cons()::LANGUAGE_BACKEND) }}</option>
                    <option value="{{ cons()::PERCENTAGE }}">{{ tt_trans('Percentage', cons()::LANGUAGE_BACKEND) }}
                    </option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
        </form>
    </x-modal>

    <x-modal id="addReferralModal" title="Add New Level" size="">

        <form method="POST" action="{{route('panel.referral-level-store')}}" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="referral_setting_id" value="">

            <div class="mb-3">
                <label class="form-label">{{tt_trans('Level Image',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="file" name="image" class="form-control">
            </div>

            <div class="mb-3">
                <label class="form-label">{{tt_trans('Level name',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="text" name="name" class="form-control" placeholder="Enter Level Name">
            </div>
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Level commission amount',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="number" step="any" name="commission" class="form-control" placeholder="Enter Comission">
            </div>
            <button type="submit" class="btn btn-primary">{{tt_trans('Save Now',cons()::LANGUAGE_BACKEND)}}</button>
        </form>

    </x-modal>

    <x-modal id="editReferralModal" title="Update Level" size="">

        <form method="POST"  enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="referral_setting_id" value="">
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Level Image',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="file" name="image" class="form-control">
            </div>

            <div class="mb-3">
                <label class="form-label">{{tt_trans('Level name',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="text" name="name" class="form-control" placeholder="Enter Level Name">
            </div>
            <div class="mb-3">
                <label class="form-label">{{tt_trans('Level commission amount',cons()::LANGUAGE_BACKEND)}}</label>
                <input type="number" step="any" name="commission" class="form-control" placeholder="Enter Commission">
            </div>
            <button type="submit" class="btn btn-primary">{{tt_trans('Update Now',cons()::LANGUAGE_BACKEND)}}</button>
        </form>

    </x-modal>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('.settings').on('click', function() {
                $('#referralSettingModal').find('input[name=name]').val($(this).data('setting'))
                $('#referralSettingModal').find('select[name=status]').val($(this).data('status'))
                $('#referralSettingModal').find('select[name=type]').val($(this).data('type'))
            })

            $('.add').on('click', function() {
                $('#addReferralModal').find('input[name=referral_setting_id]').val($(this).data('setting'))
            })

            $('.edit').on('click', function() {
                $('#editReferralModal').find('form').attr('action',$(this).data('action'))
                $('#editReferralModal').find('input[name=referral_setting_id]').val($(this).data('setting'))
                $('#editReferralModal').find('input[name=name]').val($(this).data('name'))
                $('#editReferralModal').find('input[name=commission]').val($(this).data('commission'))
            })
        })
    </script>
@endpush
