@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans('All Referral Commissions', cons()::LANGUAGE_BACKEND) }}</h4>
            <form method="GET">
                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div class="position-relative">
                        <input type="text" name="trx" class="form-control form-control-sm ps-35"
                            placeholder="{{ tt_trans('Search trx...', cons()::LANGUAGE_BACKEND) }}"
                            value="{{ request()->trx }}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <div class="position-relative">
                            <input type="text" name="from" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{ tt_trans('MM/DD/YYYY', cons()::LANGUAGE_BACKEND) }}"
                                value="{{ request()->from }}">
                        </div>
                        <span>{{ tt_trans('to', cons()::LANGUAGE_BACKEND) }}</span>
                        <div class="position-relative">
                            <input type="text" name="to" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{ tt_trans('MM/DD/YYYY', cons()::LANGUAGE_BACKEND) }}"
                                value="{{ request()->to }}">
                        </div>
                    </div>

                    @if (request()->has('trx') || request()->has('to') || request()->has('from'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif

                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i> {{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}
                    </button>
                </div>
            </form>
        </div>
        <div class="card-body">

            <x-table :paginations="$comissions">
                <tr>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Commission From', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Commission To', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-profile-line"></i> {{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-calendar-2-line"></i>
                        {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}</th>

                    <th scope="col"><i class="ri-wallet-2-line"></i>
                        {{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</th>

                </tr>

                <x-slot name="tablebody">
                    @forelse ($comissions as $commission)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('users', $commission->commissionFrom->image) }}" alt="image"
                                        class="avatar-lg">
                                    <div>
                                        <h6 class="text-sm mb-0"><a
                                                href="{{ route('panel.user.details', $commission->commissionFrom->id) }}"
                                                class="text-primary text-line-1 w-150px">{{ $commission->commissionFrom->full_name }}</a>
                                        </h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted text-line-1 w-150px">
                                            {{ $commission->commissionFrom->email }}</p>
                                    </div>
                                </div>
                            </td>

                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('users', $commission->commissionTo->image) }}" alt="image"
                                        class="avatar-lg">
                                    <div>
                                        <h6 class="text-sm mb-0"><a
                                                href="{{ route('panel.user.details', $commission->commissionTo->id) }}"
                                                class="text-primary">{{ $commission->commissionTo->full_name }}</a>
                                        </h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted">
                                            {{ $commission->commissionTo->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>{{ $commission->trx }}</td>
                            <td>{{ dateFormatter($commission->created_at) }}</td>

                            <td>
                                {{ formatter($commission->amount, true) }}
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse

                </x-slot>

            </x-table>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $(".datepickerWithIcon").datepicker({
                showOn: "button",
                buttonImageOnly: false,
            });


        })
    </script>
@endpush
