@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between ga-2">
            <h4 class="card-title mb-0">{{ tt_trans('All Users Logins', cons()::LANGUAGE_BACKEND) }}</h4>
            <form  method="GET">
                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div class="position-relative">
                        <input type="text" name="name" class="form-control form-control-sm ps-35"
                            placeholder="{{tt_trans('Search name,email',cons()::LANGUAGE_BACKEND)}}" value="{{request()->name}}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <div class="position-relative">
                            <input type="text" name="from" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{tt_trans('MM/DD/YYYY',cons()::LANGUAGE_BACKEND)}}" value="{{request()->from}}">
                        </div>
                        <span>{{tt_trans('to',cons()::LANGUAGE_BACKEND)}}</span>
                        <div class="position-relative">
                            <input type="text" name="to" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{tt_trans('MM/DD/YYYY',cons()::LANGUAGE_BACKEND)}}" value="{{request()->to}}">
                        </div>
                    </div>

                    @if (request()->has('name') || request()->has('to') || request()->has('from'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif


                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i> {{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}
                    </button>
                </div>
            </form>
        </div>
        <div class="card-body">

            <x-table :paginations="$logins">
                <tr>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Ip Address', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Location', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Browser', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Operating System', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-calendar-2-line"></i>
                        {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}</th>

                </tr>

                <x-slot name="tablebody">
                    @forelse ($logins as $login)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('users', $login->user->image) }}" alt="image"
                                        class="avatar-lg">
                                    <div>
                                        <h6 class="text-sm mb-0"><a
                                                href="{{ route('panel.user.details', $login->user->id) }}"
                                                class="text-primary text-line-1 w-150px">{{ $login->user->full_name }}</a></h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted text-line-1 w-150px">
                                            {{ $login->user->email }}</p>
                                    </div>
                                </div>
                            </td>

                            <td>{{ $login->ip_address }}</td>
                            <td>{{ $login->location }}</td>
                            <td>{{ $login->browser }}</td>
                            <td>{{ $login->operating_system }}</td>
                            <td>{{ dateFormatter($login->created_at) }}</td>


                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse

                </x-slot>

            </x-table>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $(".datepickerWithIcon").datepicker({
                showOn: "button",
                buttonImageOnly: false,
            });


        })
    </script>
@endpush
