@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
            <h4 class="card-title mb-0">{{ tt_trans('Manage Roles', cons()::LANGUAGE_BACKEND) }}</h4>
            <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#add">
                <i class="ri-add-circle-line"></i> {{ tt_trans('Add New Role', cons()::LANGUAGE_BACKEND) }}
            </button>
        </div>
        <div class="card-body">
            <x-table :paginations="$roles">
                <tr>
                    <th scope="col"><i class="ri-account-circle-line"></i>{{ tt_trans('Role', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-group-2-line"></i> {{ tt_trans('Admins', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-pages-line"></i> {{ tt_trans('Permissions', cons()::LANGUAGE_BACKEND) }}
                    </th>

                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">

                    @forelse ($roles as $role)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="card-icon bg-primary item-center text-white rounded-circle">
                                        <span class="text-xxl">
                                            <iconify-icon icon="bi:person"></iconify-icon>
                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="text-sm mb-1">{{ $role->name }}</h6>
                                        <p class="text-xs mb-0 line-height-1 text-muted">
                                            {{ 'created ' . dateFormatter($role->created_at) }}</p>
                                    </div>
                                </div>
                            </td>

                            @php
                                $admins = \App\Models\Admin::role($role->name)->get();
                            @endphp

                            <td>

                                <ul class="avatar-chain-list" data-bs-toggle="tooltip"
                                    data-bs-title="Total {{$admins->count()}}" data-bs-placement="left">
                                    @forelse ($admins as $admin)
                                        @if ($loop->iteration > 3)
                                            <li>
                                                <div
                                                    class="avatar-md bg-light item-center border border-2 border-white rounded-circle text-xs">
                                                    {{ $admins->count() - 3 }}+
                                                </div>
                                            </li>
                                        @else
                                            <li>
                                                <img src="{{getFile('staff', $admin->image)}}" alt="image"
                                                    class="avatar-md border border-2 border-white rounded-circle">
                                            </li>
                                        @endif
                                    @empty

                                        <li>
                                            <div
                                                class="avatar-md bg-light item-center border border-2 border-white rounded-circle text-xs">
                                                0
                                            </div>
                                        </li>
                                    @endforelse

                                </ul>
                            </td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    @foreach ($role->permissions as $perm)
                                        <span class="badge badge-light">{{ $perm->name }}</span>
                                    @endforeach

                                </div>
                            </td>

                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <button type="button" class="btn btn-icon btn-primary rounded-circle edit"
                                        data-role="{{ $role->id }}" data-name="{{ $role->name }}"
                                        data-bs-toggle="modal" data-bs-target="#edit"
                                        data-action="{{ route('panel.roles.update', $role->id) }}">
                                        <i class="ri-edit-line"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty

                        <x-no-data></x-no-data>
                    @endforelse


                </x-slot>

            </x-table>
        </div>
    </div>

    <x-modal title="Add New Role">
        <form method="POST" action="{{ route('panel.roles.store') }}">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Role name', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="name" class="form-control @error('email') is-invalid @enderror"
                    placeholder="Enter Role Name" required value="{{ old('name') }}">
                @error('name')
                    <div class="invalid-feedback">
                        {{ tt_trans($message, cons()::LANGUAGE_NOTIFICATION) }}
                    </div>
                @enderror
            </div>
            <div class="mb-4">
                <div class="d-flex align-items-center gap-3 mb-3">
                    <label class="form-label">{{ tt_trans('Role permission', cons()::LANGUAGE_BACKEND) }}</label>
                    <div class="form-check style-check d-flex align-items-center gap-2">
                        <input class="form-check-input" type="checkbox" id="checkAll">
                        <label class="form-label mb-0" for="checkAll">
                            {{ tt_trans('Check All', cons()::LANGUAGE_BACKEND) }}
                        </label>


                    </div>
                </div>
                <div class="d-flex flex-wrap align-items-center gap-3 allPermissions" id="allPermissions">
                    @foreach ($permissions as $permission)
                        <div class="form-check style-check d-flex align-items-center gap-2">
                            <input class="form-check-input" name="permissions[]" value="{{ $permission->name }}"
                                type="checkbox" id="role-{{ $permission->id }}">
                            <label class="form-check-label text-sm" for="role-{{ $permission->id }}">
                                {{ tt_trans($permission->name, cons()::LANGUAGE_BACKEND) }}
                            </label>
                        </div>
                    @endforeach

                    @error('permissions')
                        <div class="invalid-feedback">
                            {{ tt_trans($message, cons()::LANGUAGE_NOTIFICATION) }}
                        </div>
                    @enderror
                </div>
            </div>
            <button type="submit" class="btn btn-primary">{{ tt_trans('Save Now', cons()::LANGUAGE_BACKEND) }}</button>
        </form>
    </x-modal>

    <x-modal title="Update Role" id="edit">
        <form method="POST">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Role name', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="name" class="form-control" placeholder="Enter Role Name" required
                    value="{{ old('name') }}">
            </div>
            <div class="mb-4">
                <div class="d-flex align-items-center gap-3 mb-3">
                    <label class="form-label">{{ tt_trans('Role permission', cons()::LANGUAGE_BACKEND) }}</label>
                    <div class="form-check style-check d-flex align-items-center gap-2">
                        <input class="form-check-input" type="checkbox" id="checkAll">
                        <label class="form-label mb-0" for="checkAll">
                            {{ tt_trans('Check All', cons()::LANGUAGE_BACKEND) }}
                        </label>
                    </div>
                </div>
                <div class="d-flex flex-wrap align-items-center gap-3 allPermissions" id="allPermissionsForEdit">

                </div>
            </div>
            <button type="submit" class="btn btn-primary">{{ tt_trans('Update Now', cons()::LANGUAGE_BACKEND) }}</button>
        </form>
    </x-modal>
@endsection



@push('script')
    <script>
        $(function() {
            'use strict'

            $(document).on('click', "#checkAll", function() {
                $('.allPermissions input:checkbox').not(this).prop('checked', this.checked);
            });

            $('.edit').on('click', function() {
                $('#edit').find('form').attr('action', $(this).data('action'))
                $('#edit').find('input[name=name]').val($(this).data('name'))
                sendHttpRequest('GET', "{{ route('panel.permission.fetch') }}", {
                    id: $(this).data('role')
                }, '#allPermissionsForEdit');
            })


        })
    </script>
@endpush
