@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::ELEMENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-5">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title mb-0">{{ tt_trans('Image Section', cons()::LANGUAGE_BACKEND) }}</h4>
                        <a href="{{route('panel.content', 'brand')}}" class="btn btn-light"><i class="ri-arrow-left-line"></i>{{tt_trans('Back',cons()::LANGUAGE_BACKEND)}}</a>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <input type="hidden" name="images" value="image">

                            <?= builder([
                                    [
                                        'type' => 'image',
                                        'name' => 'content[image]',
                                        'label' => 'Brand Image',
                                        'value' => isset($element) ? $element->content->image : '',
                                        'size' => '300x100',
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'input_attributes' => [],
                                    ]
                            
                                ]) ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
