@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::ELEMENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card h-100">
                    <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
                        @isset($element)
                            <h4 class="card-title mb-0">{{ tt_trans('Update', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="{{ route('panel.content', $element->section_name) }}" class="btn btn-sm btn-light">
                                <i class="ri-arrow-left-line"></i> {{ tt_trans('Back') }}
                            </a>
                        @else
                            <h4 class="card-title mb-0">{{ tt_trans('Create', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="{{ route('panel.content', request()->section) }}" class="btn btn-sm btn-light">
                                <i class="ri-arrow-left-line"></i> {{ tt_trans('Back') }}
                            </a>
                        @endisset


                    </div>
                    <div class="card-body">
                        <div class="row gy-3">

                            <?= builder([
                                    [
                                        'type' => 'text',
                                        'name' => 'content[title]',
                                        'label' => 'Title',
                                        'value' => isset($element) ? $element->content->title : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[date]',
                                        'label' => 'Date',
                                        'value' => isset($element) ? $element->content->date : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'ai_enabled' => false,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'textarea',
                                        'name' => 'content[description]',
                                        'label' => 'Description',
                                        'value' => isset($element) ? $element->content->description : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                ]) ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection
