@extends('backend.layouts.master')

@section('panel')
    <form method="POST"  enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::ELEMENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card h-100">
                    <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
                        @isset($element)
                            <h4 class="card-title mb-0">{{ tt_trans('Update', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="{{ route('panel.content', $element->section_name) }}" class="btn btn-sm btn-light">
                                <i class="ri-arrow-left-line"></i> {{ tt_trans('Back') }}
                            </a>
                        @else
                            <h4 class="card-title mb-0">{{ tt_trans('Create', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="{{ route('panel.content', request()->section) }}" class="btn btn-sm btn-light">
                                <i class="ri-arrow-left-line"></i> {{ tt_trans('Back') }}
                            </a>
                        @endisset


                    </div>
                    <div class="card-body">
                        <div class="row gy-3">

                            <?= builder([
                                    [
                                        'type' => 'icon',
                                        'name' => 'content[icon]',
                                        'label' => 'Icon',
                                        'value' => isset($element) ? $element->content->icon : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[link]',
                                        'label' => 'Link',
                                        'value' => isset($element) ? $element->content->link : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                ]) ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
