@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::ELEMENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-8">
                <div class="card h-100">
                    <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
                        @isset($element)
                            <h4 class="card-title mb-0">{{ tt_trans('Update', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="{{ route('panel.content', $element->section_name) }}" class="btn btn-sm btn-light">
                                <i class="ri-arrow-left-line"></i> {{ tt_trans('Back') }}
                            </a>
                        @else
                            <h4 class="card-title mb-0">{{ tt_trans('Create', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="{{ route('panel.content', request()->section) }}" class="btn btn-sm btn-light">
                                <i class="ri-arrow-left-line"></i> {{ tt_trans('Back') }}
                            </a>
                        @endisset


                    </div>
                    <div class="card-body">
                        <div class="row gy-3">

                            <?= builder([
                                    [
                                        'type' => 'text',
                                        'name' => 'content[name]',
                                        'label' => 'Name',
                                        'value' => isset($element) ? $element->content->name : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[position]',
                                        'label' => 'Position',
                                        'value' => isset($element) ? $element->content->position : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[facebook_link]',
                                        'label' => 'Facebook Link',
                                        'value' => isset($element) ? $element->content->facebook_link : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => false,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[twitter_link]',
                                        'label' => 'Twitter Link',
                                        'value' => isset($element) ? $element->content->twitter_link : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => false,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[linkedin_link]',
                                        'label' => 'Linkedin Link',
                                        'value' => isset($element) ? $element->content->linkedin_link : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => false,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[instagram_link]',
                                        'label' => 'Instagram Link',
                                        'value' => isset($element) ? $element->content->instagram_link : '',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => false,
                                        'input_attributes' => [],
                                    ],
                                ]) ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-4">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Image Section', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <input type="hidden" name="images" value="image,image_one">

                            <?= builder([
                                    [
                                        'type' => 'image',
                                        'name' => 'content[image]',
                                        'label' => 'Profile Image',
                                        'value' => isset($element) ? $element->content->image : '',
                                        'size' => '100x100',
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                ]) ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
